package com.valtech.example.plantwateringdrone;

import org.junit.Ignore;
import org.junit.Test;

import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;

import static org.junit.Assert.*;

public class UtilTest {
    @Test
    @Ignore("assume local webserver server with stored file running")
    public void fromLocalHtmlTag() {
        BufferedImage image = Util.imageFromUrlOrHtmlTag("<img src=\"files/ficus-benjamin.jpg\"/>");
        assertNotNull(image);
    }

    @Test
    public void isHtmlTag_withTag() {
        assertTrue(Util.isHtmlTag("<img src=\"files/ficus-benjamin.jpg\"/>"));
    }

    @Test
    public void isHtmlTag_withPath() {
        assertFalse(Util.isHtmlTag("files/ficus-benjamin.jpg"));
    }

    @Test
    public void isHtmlTag_withUrl() {
        assertFalse(Util.isHtmlTag("https://example.com/img.jpg"));
    }

    @Test
    public void getUrlFromTag_withUrl() throws MalformedURLException {
        assertEquals(new URL("http://localhost/files/ficus-benjamin.jpg"), Util.getUrlFromTag("<img src=\"files/ficus-benjamin.jpg\"/>"));
    }

    @Test
    public void getUrlFromTag_withPath() throws MalformedURLException {
        assertEquals(new URL("http://localhost/files/ficus-benjamin.jpg"), Util.getUrlFromTag("files/ficus-benjamin.jpg"));
    }
}