package com.valtech.example.plantwateringdrone;

import com.valtech.example.plantwateringdrone.api.Aliveness;
import com.valtech.example.plantwateringdrone.api.IJudgeAliveness;
import com.valtech.example.plantwateringdrone.stage1.SimpleJudgeAliveness;
import org.junit.Before;
import org.junit.Test;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;

import static org.junit.Assert.*;

public class SimpleJudgeAlivenessTest {
    private static final double DELTA = 0.0001;
    private IJudgeAliveness judgeAliveness;

    @Before
    public void setUp() throws Exception {
        judgeAliveness = new SimpleJudgeAliveness();
    }

    @Test
    public void determine_whenNullImage() {
        assertEquals(Aliveness.UNCLEAR, judgeAliveness.determine(null, null));
    }

    @Test
    public void determine_whenGreenPlant() throws IOException {
        assertEquals(Aliveness.ALIVE, judgeAliveness.determine(null, getGreenPlantImage()));
    }

    @Test
    public void percentageOfGreenPixel_withGreenImage() throws IOException {
        float p = SimpleJudgeAliveness.percentageOfGreenPixel(getGreenPlantImage());
        assertEquals(0.7706125, p, DELTA);
    }

    private static BufferedImage getGreenPlantImage() throws IOException {
        InputStream stream = SimpleJudgeAlivenessTest.class.getResourceAsStream("/ficus-benjamin.jpg");
        return ImageIO.read(stream);
    }
}