package com.valtech.example.plantwateringdrone;

import com.valtech.example.plantwateringdrone.api.IdentifyPlant;
import com.valtech.example.plantwateringdrone.api.PlantIdentification;
import com.valtech.example.plantwateringdrone.stage1.SimplePlantIdentification;
import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.*;

public class IdentifyPlantTest {
    private IdentifyPlant identifyPlant;

    @Before
    public void setup() {
        identifyPlant = new SimplePlantIdentification();
    }

    @Test
    public void when_nullImage() {
        PlantIdentification plant = identifyPlant.identifyPlant(null);
        assertNotNull(plant);
        assertEquals(PlantIdentification.NO_PLANT, plant);
    }

    @Test
    public void when_bogusImage() {
        PlantIdentification plant = identifyPlant.identifyPlant(null);
        assertNotNull(plant);
        assertEquals(PlantIdentification.NO_PLANT, plant);
    }

}