package com.valtech.example.plantwateringdrone.stage1;

import com.valtech.example.plantwateringdrone.api.Aliveness;
import com.valtech.example.plantwateringdrone.api.IJudgeAliveness;
import com.valtech.example.plantwateringdrone.api.PlantIdentification;

import java.awt.*;
import java.awt.image.BufferedImage;

public class SimpleJudgeAliveness implements IJudgeAliveness {
    @Override
    public Aliveness determine(PlantIdentification plantIdentification, BufferedImage image) {
        if (image == null) {
            return Aliveness.UNCLEAR;
        }

        float percentGreenPxs = percentageOfGreenPixel(image);
        if (percentGreenPxs > 0.75) {
            return Aliveness.ALIVE;
        } else {
            return Aliveness.DEAD;
        }
    }

    public static float percentageOfGreenPixel(BufferedImage image) {
        int greenPxs = 0;
        for (int x = 0; x < image.getWidth(); x++) {
            for (int y = 0; y < image.getHeight(); y++) {
                Color color = new Color(image.getRGB(x, y));
                greenPxs += color.getGreen() > 150 ? 1 : 0;
                //int green = (px_rgb & 0x0000ff00) >> 8;
                //greenPxs += green != 0 ? 1 : 0;
            }
        }
        return (1.0f * greenPxs) / (1.0f * image.getHeight() * image.getWidth());
    }
}
