package com.valtech.example.plantwateringdrone.fitnesse;

import com.valtech.example.plantwateringdrone.Util;
import com.valtech.example.plantwateringdrone.api.Aliveness;
import com.valtech.example.plantwateringdrone.api.IJudgeAliveness;
import com.valtech.example.plantwateringdrone.api.IdentifyPlant;
import com.valtech.example.plantwateringdrone.api.PlantIdentification;
import com.valtech.example.plantwateringdrone.stage1.SimpleJudgeAliveness;
import com.valtech.example.plantwateringdrone.stage1.SimplePlantIdentification;

import java.awt.image.BufferedImage;

public class PlantSpecies {
    private final IdentifyPlant identifyPlant;

    private BufferedImage image;
    private PlantIdentification plantIdentification;

    public PlantSpecies() {
        // e.g. read from config file
        identifyPlant = new SimplePlantIdentification();
    }

    public void execute() {
        plantIdentification = identifyPlant.identifyPlant(image);
    }

    public void setImageOfPlant(String pictureUrl) {
        image = Util.imageFromUrlOrHtmlTag(pictureUrl);
    }

    public String Species() {
        return identifyPlant.getSpecies();
    }
}
