package com.valtech.example.plantwateringdrone.fitnesse;

import com.valtech.example.plantwateringdrone.Util;
import com.valtech.example.plantwateringdrone.api.Aliveness;
import com.valtech.example.plantwateringdrone.api.IJudgeAliveness;
import com.valtech.example.plantwateringdrone.api.IdentifyPlant;
import com.valtech.example.plantwateringdrone.api.PlantIdentification;
import com.valtech.example.plantwateringdrone.stage1.SimpleJudgeAliveness;
import com.valtech.example.plantwateringdrone.stage1.SimplePlantIdentification;

import java.awt.image.BufferedImage;

public class IsPlantStillAlive {
    private final IdentifyPlant identifyPlant;
    private final IJudgeAliveness judgeAlivenessOfPlant;

    private BufferedImage image;
    private Aliveness isPlantAlive;

    public IsPlantStillAlive() {
        // e.g. read from config file
        identifyPlant = new SimplePlantIdentification();
        judgeAlivenessOfPlant = new SimpleJudgeAliveness();
    }

    public void execute() {
        PlantIdentification plantIdentification = identifyPlant.identifyPlant(image);
        isPlantAlive = judgeAlivenessOfPlant.determine(plantIdentification, image);
    }

    public void setPictureOfPlant(String pictureUrl) {
        image = Util.imageFromUrlOrHtmlTag(pictureUrl);
    }

    public String IsAlive() {
        return isPlantAlive == Aliveness.ALIVE ? "yes" : "no";
    }
}
