package com.valtech.example.plantwateringdrone;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Util {
    private static final Logger LOGGER = Logger.getLogger("Util");

    public static BufferedImage imageFromUrlOrHtmlTag(String tagOrUrl) {
        URL url = getUrlFromTag(tagOrUrl);

        assert url != null;
        try {
            return ImageIO.read(url);
        } catch (
                IOException e) {
            LOGGER.log(Level.WARNING, "cannot load image from URL " + url.toString(), e);
            return null;
        }
    }

    public static URL getUrlFromTag(String tagOrUrl) {
        String url;
        int startOf = tagOrUrl.indexOf("=\"");
        if (startOf > 0) {
            int endOf = tagOrUrl.indexOf("\"", startOf + 2);
            url = tagOrUrl.substring(startOf + 2, endOf);
        } else {
            url = tagOrUrl;
        }

        if (!url.startsWith("http")) {
            url = "http://localhost/" + url;
        }

        try {
            return new URL(url);
        } catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, "cannot create URL from " + url, e);
            return null;
        }
    }

    public static boolean isHtmlTag(String tagOrUrl) {
        return tagOrUrl.startsWith("<");
    }
}
