/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.parser.HeaderLine;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.Literal;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolTreeWalker;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

public class Headings
extends SymbolType
implements Rule,
Translation {
    public static final Headings symbolType = new Headings();
    private static final String STYLE = "STYLE";
    private static final String[] OPTION_KEYS = new String[]{"STYLE"};

    public Headings() {
        super("Headings");
        this.wikiMatcher(new Matcher().startLineOrCell().string("!headings"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        Symbol body = parser.parseToEnd(SymbolType.Newline);
        new OptionParser(current, body).parse();
        current.add(body);
        return new Maybe<Symbol>(current);
    }

    @Override
    public String toTarget(Translator translator, Symbol current) {
        List<Symbol> headerLines = this.extractHeaderLines(translator);
        HeadingContentBuilder headingContentBuilder = new HeadingContentBuilder(headerLines, ListStyle.byNameIgnoreCase(current.getProperty(STYLE)));
        HtmlElement html = headingContentBuilder.htmlElements();
        return html.html();
    }

    private List<Symbol> extractHeaderLines(Translator translator) {
        HtmlTranslator htmlTranslator = (HtmlTranslator)translator;
        SourcePage sourcePage = htmlTranslator.getPage();
        return sourcePage.getSymbols(HeaderLine.symbolType);
    }

    static String extractTextFromHeaderLine(Symbol headerLine) {
        final StringBuilder sb = new StringBuilder();
        headerLine.walkPreOrder(new SymbolTreeWalker(){

            @Override
            public boolean visit(Symbol node) {
                if (node.isType(SymbolType.Text) || node.isType(Literal.symbolType) || node.isType(SymbolType.Whitespace)) {
                    sb.append(node.getContent());
                }
                return true;
            }

            @Override
            public boolean visitChildren(Symbol node) {
                return true;
            }
        });
        return sb.toString();
    }

    static String buildIdOfHeaderLine(String textFromHeaderLine) {
        return HtmlUtil.remainRfc3986UnreservedCharacters(textFromHeaderLine);
    }

    class OptionParser {
        private final Symbol current;
        private final Symbol body;
        private String previousOption = null;

        OptionParser(Symbol current, Symbol body) {
            this.current = current;
            this.body = body;
        }

        void parse() {
            for (Symbol option : this.body.getChildren()) {
                this.handleSymbol(option);
            }
            this.finishSymbols();
        }

        private void handleSymbol(Symbol option) {
            if (!option.isType(SymbolType.Whitespace)) {
                this.handleNonWhitespace(option);
            }
        }

        private void finishSymbols() {
            this.handleOptionAsValue(null);
        }

        private void handleNonWhitespace(Symbol symbol) {
            String option = symbol.getContent();
            if (this.isOptionAKey(option)) {
                this.handleOptionAsKeyCandidate(option);
            } else {
                this.handleOptionAsValue(option);
            }
        }

        private void handleOptionAsValue(String option) {
            if (this.isOptionAKey(this.previousOption)) {
                this.addToOptions(option);
            }
            this.previousOption = null;
        }

        private void handleOptionAsKeyCandidate(String option) {
            if (this.isOptionAKey(this.previousOption)) {
                this.addToOptions(null);
            }
            this.previousOption = option;
        }

        private boolean isOptionAKey(String candidate) {
            return candidate != null && candidate.startsWith("-") && Arrays.asList(OPTION_KEYS).contains(this.normalizeOptionKey(candidate));
        }

        private String normalizeOptionKey(String candidate) {
            return candidate.substring(1).toUpperCase();
        }

        private void addToOptions(String optionValue) {
            this.current.putProperty(this.normalizeOptionKey(this.previousOption), optionValue);
        }
    }

    class HeadingContentBuilder {
        private final List<Symbol> headerLines;
        private final Stack<HtmlTag> stack = new Stack();
        private ListStyle listStyle = ListStyle.DECIMAL;
        private HtmlTag rootElement = null;
        private boolean processed;

        HeadingContentBuilder(List<Symbol> headerLines, ListStyle listStyle) {
            this.headerLines = headerLines;
            this.listStyle = listStyle;
            this.rootElement = new HtmlTag("div");
            this.rootElement.addAttribute("class", "contents");
            this.rootElement.add(HtmlUtil.makeBold("Contents:"));
            this.stack.push(this.rootElement);
        }

        HtmlElement htmlElements() {
            for (Symbol headerLine : this.headerLines) {
                this.processed = false;
                this.htmlElements(headerLine);
            }
            return this.rootElement;
        }

        private void htmlElements(Symbol headerLine) {
            this.addListElement(headerLine);
            this.goToParent(headerLine);
            this.addListItemElement(headerLine);
            if (!this.processed) {
                this.htmlElements(headerLine);
            }
        }

        private void addListElement(Symbol headerLine) {
            if (this.getLevel(headerLine) > this.currentLevel()) {
                HtmlTag listElement = new HtmlTag("ol");
                listElement.addAttribute("style", "list-style-type: " + this.listStyle.name + ";");
                this.stack.peek().add(listElement);
                this.stack.push(listElement);
            }
        }

        private void goToParent(Symbol headerLine) {
            if (this.getLevel(headerLine) < this.currentLevel()) {
                this.stack.pop();
            }
        }

        private void addListItemElement(Symbol headerLine) {
            if (this.getLevel(headerLine) == this.currentLevel()) {
                HtmlTag listitemElement = new HtmlTag("li");
                listitemElement.addAttribute("class", "heading" + this.currentLevel());
                String textFromHeaderLine = Headings.extractTextFromHeaderLine(headerLine);
                HtmlTag anchorElement = new HtmlTag("a", textFromHeaderLine);
                anchorElement.addAttribute("href", "#" + Headings.buildIdOfHeaderLine(textFromHeaderLine));
                listitemElement.add(anchorElement);
                this.stack.peek().add(listitemElement);
                this.processed = true;
            }
        }

        private int currentLevel() {
            return this.stack.size() - 1;
        }

        private int getLevel(Symbol headerLine) {
            return Integer.parseInt(headerLine.getProperty("level"));
        }
    }

    public static enum ListStyle {
        DECIMAL("decimal"),
        DECIMAL_LEADING_ZERO("decimal-leading-zero"),
        LOWER_ROMAN("lower-roman"),
        UPPER_ROMAN("upper-roman"),
        LOWER_ALPHA("lower-alpha"),
        UPPER_ALPHA("upper-alpha"),
        NONE("none");

        private final String name;

        private ListStyle(String name) {
            this.name = name;
        }

        static ListStyle byNameIgnoreCase(String name) {
            for (ListStyle listStyle : ListStyle.values()) {
                if (!listStyle.name.equalsIgnoreCase(name)) continue;
                return listStyle;
            }
            return DECIMAL;
        }
    }
}

