/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlTag;
import fitnesse.wikitext.parser.Headings;
import fitnesse.wikitext.parser.LineRule;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;

public class HeaderLine
extends SymbolType
implements Translation {
    public static final HeaderLine symbolType = new HeaderLine();

    public HeaderLine() {
        super("HeaderLine");
        this.wikiMatcher(new Matcher().startLineOrCell().string("!1"));
        this.wikiMatcher(new Matcher().startLineOrCell().string("!2"));
        this.wikiMatcher(new Matcher().startLineOrCell().string("!3"));
        this.wikiMatcher(new Matcher().startLineOrCell().string("!4"));
        this.wikiMatcher(new Matcher().startLineOrCell().string("!5"));
        this.wikiMatcher(new Matcher().startLineOrCell().string("!6"));
        this.wikiRule(new LineRule());
        this.htmlTranslation(this);
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        HtmlTag result = new HtmlTag("h" + symbol.getProperty("level"));
        this.addInnerHtml(result, translator, symbol);
        this.addAttributeId(result, translator, symbol.childAt(0));
        return result.html();
    }

    private void addInnerHtml(HtmlTag result, Translator translator, Symbol symbol) {
        String heading = translator.translate(symbol.childAt(0)).trim();
        result.add(heading);
    }

    private void addAttributeId(HtmlTag result, Translator translator, Symbol symbol) {
        String textFromHeaderLine = Headings.extractTextFromHeaderLine(symbol);
        String value = Headings.buildIdOfHeaderLine(textFromHeaderLine);
        result.addAttribute("id", value);
    }
}

