/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.util.StringUtils;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;

public class FrontMatter
extends SymbolType
implements Rule,
Translation {
    public static final FrontMatter symbolType = new FrontMatter();
    public static final SymbolType keyValueSymbolType = new SymbolType("KeyValue");
    private static final String FRONT_MATTER_DELIMITER_LF = "---\n";
    private static final String FRONT_MATTER_DELIMITER_CRLF = "---\r\n";
    private static SymbolProvider SYMBOL_PROVIDER = new SymbolProvider(new SymbolType[]{CloseFrontMatter.access$000(), SymbolType.Colon, SymbolType.Whitespace, SymbolType.Newline, SymbolType.Text});

    FrontMatter() {
        super("FrontMatter");
        this.wikiMatcher(new Matcher().startLine().string(FRONT_MATTER_DELIMITER_LF));
        this.wikiMatcher(new Matcher().startLine().string(FRONT_MATTER_DELIMITER_CRLF));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        if (current.getStartOffset() != 0) {
            return Symbol.nothing;
        }
        Symbol frontMatter = parser.parseToWithSymbols(CloseFrontMatter.symbolType, SYMBOL_PROVIDER, 0);
        if (!parser.getCurrent().isType(CloseFrontMatter.symbolType)) {
            return Symbol.nothing;
        }
        Maybe<Symbol> yaml = this.processYaml(current, frontMatter);
        if (yaml.isNothing()) {
            return Symbol.nothing;
        }
        return new Maybe<Symbol>(current);
    }

    private Maybe<Symbol> processYaml(Symbol yaml, Symbol symbolList) {
        boolean addToPrevious = false;
        String key = null;
        String value = "";
        for (Symbol symbol : symbolList.getChildren()) {
            if (symbol.isType(SymbolType.Whitespace) && key == null) {
                addToPrevious = true;
                continue;
            }
            if (symbol.isType(SymbolType.Text) && key == null) {
                key = symbol.getContent();
                continue;
            }
            if (symbol.isType(SymbolType.Text) || symbol.isType(SymbolType.Whitespace) || symbol.isType(SymbolType.Colon) && !StringUtils.isBlank(value)) {
                value = value + symbol.getContent();
                continue;
            }
            if (symbol.isType(SymbolType.Colon)) {
                if (key != null) continue;
                return Symbol.nothing;
            }
            if (symbol.isType(SymbolType.Newline)) {
                if (key != null) {
                    if (addToPrevious) {
                        yaml.getChildren().get(yaml.getChildren().size() - 1).add(this.yamlLine(key, value.trim()));
                    } else {
                        yaml.add(this.yamlLine(key, value.trim()));
                    }
                }
                key = null;
                value = "";
                addToPrevious = false;
                continue;
            }
            return Symbol.nothing;
        }
        return new Maybe<Symbol>(yaml);
    }

    private Symbol yamlLine(String key, String value) {
        return new Symbol(keyValueSymbolType).add(key).add(value);
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        return "";
    }

    private static class CloseFrontMatter
    extends SymbolType {
        private static final CloseFrontMatter symbolType = new CloseFrontMatter();

        private CloseFrontMatter() {
            super("EndOfFrontMatter");
            this.wikiMatcher(new Matcher().startLine().string(FrontMatter.FRONT_MATTER_DELIMITER_LF));
            this.wikiMatcher(new Matcher().startLine().string(FrontMatter.FRONT_MATTER_DELIMITER_CRLF));
        }
    }
}

