/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import java.util.List;

public class AnchorReference
extends SymbolType
implements Rule,
Translation {
    public AnchorReference() {
        super("AnchorReference");
        this.wikiMatcher(new Matcher().string(".#"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        List<Symbol> tokens = parser.moveNext(new SymbolType[]{SymbolType.Text});
        if (tokens.isEmpty()) {
            return Symbol.nothing;
        }
        String anchor = tokens.get(0).getContent();
        if (!ScanString.isWord(anchor)) {
            return Symbol.nothing;
        }
        return new Maybe<Symbol>(current.add(tokens.get(0)));
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        String name = translator.translate(symbol.childAt(0));
        return HtmlUtil.makeLink("#" + name, ".#" + name).html();
    }
}

