/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.search;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.NoPruningStrategy;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.WikiSourcePage;
import fitnesse.wiki.WikiWordReference;
import fitnesse.wiki.search.PageFinder;
import fitnesse.wikitext.parser.Alias;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolTreeWalker;
import fitnesse.wikitext.parser.WikiWord;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class WhereUsedPageFinder
implements TraversalListener<WikiPage>,
PageFinder,
SymbolTreeWalker {
    private final WikiPage subjectPage;
    private final TraversalListener<? super WikiPage> observer;
    private WikiPage currentPage;
    private List<WikiPage> hits = new ArrayList<WikiPage>();

    public WhereUsedPageFinder(WikiPage subjectPage, TraversalListener<? super WikiPage> observer) {
        this.subjectPage = subjectPage;
        this.observer = observer;
    }

    @Override
    public void process(WikiPage currentPage) {
        this.currentPage = currentPage;
        this.checkSymbolicLinks();
        if (!this.hits.contains(currentPage)) {
            this.checkContent();
        }
    }

    private void checkSymbolicLinks() {
        WikiPageProperty suiteProperty = this.currentPage.getData().getProperties().getProperty("SymbolicLinks");
        if (suiteProperty != null) {
            Set<String> links = suiteProperty.keySet();
            for (String link : links) {
                WikiPage linkTarget = this.currentPage.getChildPage(link);
                if (!(linkTarget instanceof SymbolicPage) || !((SymbolicPage)linkTarget).getRealPage().equals(this.subjectPage)) continue;
                this.addHit();
                break;
            }
        }
    }

    private void checkContent() {
        String content = this.currentPage.getData().getContent();
        Symbol syntaxTree = Parser.make(new ParsingPage(new WikiSourcePage(this.currentPage)), content, SymbolProvider.refactoringProvider).parse();
        syntaxTree.walkPreOrder(this);
    }

    @Override
    public void search(WikiPage page) {
        this.hits.clear();
        page.getPageCrawler().traverse(this, new NoPruningStrategy());
    }

    @Override
    public boolean visit(Symbol node) {
        WikiPage referencedPage;
        if (this.hits.contains(this.currentPage)) {
            return true;
        }
        if (node.isType(WikiWord.symbolType) && (referencedPage = new WikiWordReference(this.currentPage, node.getContent()).getReferencedPage()) != null && referencedPage.equals(this.subjectPage)) {
            this.addHit();
        }
        if (node.isType(Alias.symbolType)) {
            WikiPage referencedPage2;
            String linkText = node.childAt(1).childAt(0).getContent();
            if (linkText.contains("?")) {
                linkText = linkText.substring(0, linkText.indexOf(63));
            }
            if ((referencedPage2 = new WikiWordReference(this.currentPage, linkText).getReferencedPage()) != null && referencedPage2.equals(this.subjectPage)) {
                this.addHit();
            }
        }
        return true;
    }

    @Override
    public boolean visitChildren(Symbol node) {
        return true;
    }

    private void addHit() {
        this.hits.add(this.currentPage);
        this.observer.process(this.currentPage);
    }
}

