/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.refactoring;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.WikiSourcePage;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolTreeWalker;
import fitnesse.wikitext.parser.WikiTranslator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

class ReferenceRenamingTraverser
implements TraversalListener<WikiPage> {
    private final SymbolTreeWalker walker;
    private final Function<String, Optional<String>> symbolicLinkProcessor;
    private WikiPage currentPage;

    ReferenceRenamingTraverser(SymbolTreeWalker walker, Function<String, Optional<String>> symbolicLinkProcessor) {
        this.walker = walker;
        this.symbolicLinkProcessor = symbolicLinkProcessor;
    }

    @Override
    public void process(WikiPage currentPage) {
        this.currentPage = currentPage;
        PageData data = currentPage.getData();
        boolean pageHasChanged = this.checkSymbolicLinks(data);
        if (pageHasChanged |= this.updatePageContent(data)) {
            currentPage.commit(data);
        }
    }

    private boolean checkSymbolicLinks(PageData data) {
        boolean pageHasChanged = false;
        WikiPageProperty suiteProperty = data.getProperties().getProperty("SymbolicLinks");
        if (suiteProperty != null) {
            Set<String> links = suiteProperty.keySet();
            for (String link : links) {
                String linkTarget = suiteProperty.get(link);
                Optional<String> renamedLinkTarget = this.symbolicLinkProcessor.apply(linkTarget);
                if (!renamedLinkTarget.isPresent()) continue;
                suiteProperty.set(link, renamedLinkTarget.get());
                pageHasChanged = true;
            }
        }
        return pageHasChanged;
    }

    private boolean updatePageContent(PageData data) {
        boolean pageHasChanged;
        String content = data.getContent();
        String newContent = this.getUpdatedPageContent(content);
        boolean bl = pageHasChanged = !newContent.equals(content);
        if (pageHasChanged) {
            data.setContent(newContent);
        }
        return pageHasChanged;
    }

    private String getUpdatedPageContent(String content) {
        Symbol syntaxTree = Parser.make(new ParsingPage(new WikiSourcePage(this.currentPage)), content, SymbolProvider.refactoringProvider).parse();
        syntaxTree.walkPreOrder(this.walker);
        return new WikiTranslator(new WikiSourcePage(this.currentPage)).translateTree(syntaxTree);
    }

    WikiPage currentPage() {
        return this.currentPage;
    }
}

