/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.refactoring;

import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiWordReference;
import fitnesse.wiki.refactoring.ReferenceRenamer;
import fitnesse.wikitext.parser.Alias;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.WikiWord;
import java.util.Optional;

public class MovedPageReferenceRenamer
extends ReferenceRenamer {
    private WikiPage pageToBeMoved;
    private String newParentName;

    public MovedPageReferenceRenamer(WikiPage root, WikiPage pageToBeMoved, String newParentName) {
        super(root);
        this.pageToBeMoved = pageToBeMoved;
        this.newParentName = newParentName;
    }

    @Override
    public boolean visit(Symbol node) {
        if (node.isType(WikiWord.symbolType)) {
            new WikiWordReference(this.currentPage(), node.getContent()).wikiWordRenameMovedPageIfReferenced(node, this.pageToBeMoved, this.newParentName);
        }
        return true;
    }

    @Override
    public boolean visitChildren(Symbol node) {
        return !node.isType(Alias.symbolType);
    }

    @Override
    Optional<String> renameSymbolicLinkIfNeeded(String linkTarget) {
        return new WikiWordReference(this.currentPage(), linkTarget).getMovedPageRenamedContent(linkTarget, this.pageToBeMoved, this.newParentName);
    }
}

