/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.util.XmlUtil;
import fitnesse.wiki.WikiPageLoadException;
import fitnesse.wiki.WikiPageProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WikiPageProperties
extends WikiPageProperty
implements Serializable {
    private static final Logger LOG = Logger.getLogger(WikiPageProperties.class.getName());
    private static final long serialVersionUID = 1L;

    public WikiPageProperties() {
    }

    public WikiPageProperties(InputStream inputStream) {
        this();
        this.loadFromXmlStream(inputStream);
    }

    public WikiPageProperties(Element rootElement) {
        this();
        this.loadFromRootElement(rootElement);
    }

    public WikiPageProperties(WikiPageProperty that) {
        super(that);
    }

    public void loadFromXmlStream(InputStream inputStream) {
        Document document;
        try {
            document = XmlUtil.newDocument(inputStream);
        }
        catch (Exception e) {
            throw new WikiPageLoadException("Unable to parse XML from stream", e);
        }
        Element root = document.getDocumentElement();
        this.loadFromRootElement(root);
    }

    public void loadFromXml(String xml) {
        Document document;
        try {
            document = XmlUtil.newDocument(xml);
        }
        catch (Exception e) {
            throw new WikiPageLoadException("Unable to parse XML from string " + xml, e);
        }
        Element root = document.getDocumentElement();
        this.loadFromRootElement(root);
    }

    public void loadFromRootElement(Element root) {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            String key = node.getNodeName();
            this.LoadElement(this, (Element)node, key);
        }
    }

    private void LoadElement(WikiPageProperty context, Element element, String key) {
        WikiPageProperty newProperty = new WikiPageProperty();
        context.set(key, newProperty);
        NodeList nodes = element.getChildNodes();
        if (element.hasAttribute("value")) {
            newProperty.setValue(element.getAttribute("value"));
        } else if (nodes.getLength() == 1) {
            newProperty.setValue(nodes.item(0).getNodeValue());
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (!(childNode instanceof Element)) continue;
            this.LoadElement(newProperty, (Element)childNode, childNode.getNodeName());
        }
    }

    public String toXml() throws IOException {
        Document document = XmlUtil.newDocument();
        document.appendChild(this.makeRootElement(document));
        return XmlUtil.xmlAsString(document);
    }

    public Element makeRootElement(Document document) {
        Element root = document.createElement("properties");
        ArrayList<String> keys = new ArrayList<String>(this.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            WikiPageProperty childProperty = this.getProperty(key);
            this.toXml(childProperty, key, document, root);
        }
        return root;
    }

    private void toXml(WikiPageProperty context, String key, Document document, Element parent) {
        Element element = document.createElement(key);
        String value = context.getValue();
        if (context.hasChildren()) {
            if (value != null) {
                element.setAttribute("value", value);
            }
            Set<String> childKeys = context.keySet();
            for (String childKeyAsString : childKeys) {
                WikiPageProperty child = context.getProperty(childKeyAsString);
                if (child == null) {
                    LOG.warning("Property key \"" + childKeyAsString + "\" has null value for {" + context + "}");
                    continue;
                }
                this.toXml(child, childKeyAsString, document, element);
            }
        } else if (value != null) {
            element.appendChild(document.createTextNode(value));
        }
        parent.appendChild(element);
    }

    @Override
    public String toString() {
        return super.toString("WikiPageProperties", 0);
    }
}

