/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.ConfigurationParameter;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.SystemVariableSource;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageUtil;
import fitnesse.wiki.fs.FileSystemPageFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import util.FileUtil;

public class VersionsControllerFixture {
    public static final String TEST_DIR = "TestDir";
    private FileSystemPageFactory pageFactory;
    private WikiPage rootPage;
    private WikiPage lastUsedPage;

    public VersionsControllerFixture() {
    }

    public VersionsControllerFixture(String versionsControllerClassName) {
        Properties properties = new Properties();
        properties.setProperty(ConfigurationParameter.VERSIONS_CONTROLLER_CLASS.getKey(), versionsControllerClassName);
        this.pageFactory = new FileSystemPageFactory(properties);
    }

    public void createWikiRoot() {
        this.rootPage = this.pageFactory.makePage(new File(TEST_DIR, "RooT"), "RooT", null, new SystemVariableSource());
    }

    public WikiPage getRootPage() {
        return this.rootPage;
    }

    public void cleanUp() throws IOException {
        FileUtil.deleteFileSystemDirectory(TEST_DIR);
    }

    public Object savePageWithContent(String pageName, String content) {
        this.lastUsedPage = WikiPageUtil.addPage(this.rootPage, PathParser.parse(pageName));
        PageData data = this.lastUsedPage.getData();
        data.setContent(content);
        return this.lastUsedPage.commit(data);
    }

    public void deletePage(String pageName) {
        PageCrawler pageCrawler = this.rootPage.getPageCrawler();
        this.lastUsedPage = pageCrawler.getPage(PathParser.parse(pageName));
        this.lastUsedPage.remove();
    }

    public int historySize() {
        Collection<VersionInfo> versions = this.lastUsedPage.getVersions();
        return versions.size();
    }

    public String getVersionInfos() {
        String result = "";
        Collection<VersionInfo> versions = this.lastUsedPage.getVersions();
        for (VersionInfo version : versions) {
            result = result + version.getName() + "-" + version.getAuthor() + "-" + version.getCreationTime() + "\n";
        }
        return result;
    }

    public String contentForRevision(int n) {
        ArrayList<VersionInfo> versions = new ArrayList<VersionInfo>(this.lastUsedPage.getVersions());
        WikiPage page = this.lastUsedPage.getVersion(((VersionInfo)versions.get(versions.size() - 1 - n)).getName());
        return page.getData().getContent();
    }

    public String contentForRevisionFromPage(int n, String pageName) {
        PageCrawler pageCrawler = this.rootPage.getPageCrawler();
        this.lastUsedPage = pageCrawler.getPage(PathParser.parse(pageName));
        if (this.lastUsedPage == null) {
            return "[Error: Page doesn't exists]";
        }
        return this.contentForRevision(n);
    }

    public String contentFromPage(String pageName) {
        PageCrawler pageCrawler = this.rootPage.getPageCrawler();
        this.lastUsedPage = pageCrawler.getPage(PathParser.parse(pageName));
        if (this.lastUsedPage == null) {
            return "[Error: Page doesn't exists]";
        }
        return this.lastUsedPage.getData().getContent();
    }
}

