/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.fs.DiskFileSystem;
import fitnesse.wiki.fs.FileSystem;
import fitnesse.wiki.fs.FileVersion;
import fitnesse.wiki.fs.VersionsController;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

public class SimpleFileVersionsController
implements VersionsController {
    private final FileSystem fileSystem;

    public SimpleFileVersionsController(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public SimpleFileVersionsController() {
        this(new DiskFileSystem());
    }

    @Override
    public FileVersion[] getRevisionData(String label, File ... files) {
        FileVersion[] versions = new FileVersion[files.length];
        int counter = 0;
        for (File file : files) {
            if (!this.fileSystem.exists(file)) continue;
            versions[counter++] = new RevisionFileVersion(file, "");
        }
        return versions;
    }

    @Override
    public Collection<VersionInfo> history(File ... files) {
        return Collections.emptyList();
    }

    @Override
    public VersionInfo makeVersion(FileVersion ... fileVersions) throws IOException {
        for (FileVersion fileVersion : fileVersions) {
            this.addDirectory(fileVersion.getFile().getParentFile());
            try (InputStream content = fileVersion.getContent();){
                this.fileSystem.makeFile(fileVersion.getFile(), content);
            }
        }
        return VersionInfo.makeVersionInfo(fileVersions[0].getAuthor(), fileVersions[0].getLastModificationTime());
    }

    @Override
    public void delete(File ... files) throws IOException {
        for (File file : files) {
            this.fileSystem.delete(file);
        }
    }

    @Override
    public VersionInfo addDirectory(FileVersion dir) throws IOException {
        File filePath = dir.getFile();
        this.addDirectory(filePath);
        return VersionInfo.makeVersionInfo(dir.getAuthor(), new Date(this.fileSystem.lastModified(filePath)));
    }

    private void addDirectory(File filePath) throws IOException {
        if (!this.fileSystem.exists(filePath)) {
            this.fileSystem.makeDirectory(filePath);
        }
    }

    @Override
    public void rename(FileVersion fileVersion, File oldFile) throws IOException {
        this.fileSystem.rename(fileVersion.getFile(), oldFile);
    }

    private class RevisionFileVersion
    implements FileVersion {
        private final File file;
        private final String author;

        private RevisionFileVersion(File file, String author) {
            this.file = file;
            this.author = author;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public InputStream getContent() throws IOException {
            return new BufferedInputStream(SimpleFileVersionsController.this.fileSystem.getInputStream(this.file));
        }

        @Override
        public String getAuthor() {
            return this.author;
        }

        @Override
        public Date getLastModificationTime() {
            return new Date(SimpleFileVersionsController.this.fileSystem.lastModified(this.file));
        }
    }
}

