/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.wiki.NoSuchVersionException;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.fs.FileSystem;
import fitnesse.wiki.fs.FileVersion;
import fitnesse.wiki.fs.SimpleFileVersionsController;
import fitnesse.wiki.fs.VersionsController;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class MemoryVersionsController
implements VersionsController {
    private Map<String, FileVersions> versions = new HashMap<String, FileVersions>();
    private VersionsController persistence;

    public MemoryVersionsController(FileSystem fileSystem) {
        this.persistence = new SimpleFileVersionsController(fileSystem);
    }

    @Override
    public FileVersion[] getRevisionData(String label, File ... files) throws IOException {
        if (label == null) {
            return this.persistence.getRevisionData(null, files);
        }
        return this.getFileVersions(files[0]).getRevisionData(label);
    }

    @Override
    public Collection<VersionInfo> history(File ... files) {
        FileVersions fileVersions = this.getFileVersions(files[0]);
        if (fileVersions == null) {
            return null;
        }
        return fileVersions.history();
    }

    @Override
    public VersionInfo makeVersion(FileVersion ... fileVersions) throws IOException {
        this.persistence.makeVersion(fileVersions);
        return this.getFileVersions(fileVersions[0].getFile()).makeVersion(fileVersions);
    }

    @Override
    public VersionInfo addDirectory(FileVersion filePath) throws IOException {
        return this.persistence.addDirectory(filePath);
    }

    @Override
    public void rename(FileVersion fileVersion, File originalFile) throws IOException {
        this.persistence.rename(fileVersion, originalFile);
    }

    @Override
    public void delete(File ... files) throws IOException {
        this.persistence.delete(files);
    }

    private FileVersions getFileVersions(File file) {
        String key = file.getPath();
        FileVersions fileVersions = this.versions.get(key);
        if (fileVersions == null) {
            fileVersions = new FileVersions();
            this.versions.put(key, fileVersions);
        }
        return fileVersions;
    }

    private static class FileVersions {
        protected Map<String, FileVersion[]> versions = new TreeMap<String, FileVersion[]>();

        private FileVersions() {
        }

        protected VersionInfo makeVersion(FileVersion ... current) {
            VersionInfo version = this.makeVersionInfo(current[0]);
            this.versions.put(version.getName(), current);
            return version;
        }

        private VersionInfo makeVersionInfo(FileVersion current) {
            String name = String.valueOf(this.versions.size());
            return this.makeVersionInfo(current, name);
        }

        public Collection<VersionInfo> history() {
            LinkedList<VersionInfo> set = new LinkedList<VersionInfo>();
            for (Map.Entry<String, FileVersion[]> entry : this.versions.entrySet()) {
                set.add(this.makeVersionInfo(entry.getValue()[0], entry.getKey()));
            }
            return set;
        }

        public FileVersion[] getRevisionData(String versionName) {
            FileVersion[] version = this.versions.get(versionName);
            if (version == null) {
                throw new NoSuchVersionException("There is no version '" + versionName + "'");
            }
            return version;
        }

        protected VersionInfo makeVersionInfo(FileVersion current, String name) {
            String author = current.getAuthor();
            if (author == null) {
                author = "";
            }
            Date date = current.getLastModificationTime();
            return new VersionInfo(name, author, date);
        }
    }
}

