/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.wiki.SystemVariableSource;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageFactory;
import fitnesse.wiki.fs.FileSystem;
import fitnesse.wiki.fs.FileSystemPageFactory;
import fitnesse.wiki.fs.MemoryFileSystem;
import fitnesse.wiki.fs.MemoryVersionsController;
import java.io.File;
import java.util.Properties;

public class InMemoryPage {
    public static WikiPage makeRoot(String name) {
        return InMemoryPage.makeRoot(name, null, new MemoryFileSystem());
    }

    public static WikiPage makeRoot(String name, MemoryFileSystem fileSystem) {
        return InMemoryPage.makeRoot(name, null, fileSystem);
    }

    public static WikiPage makeRoot(String name, Properties properties) {
        return InMemoryPage.makeRoot(name, properties, new MemoryFileSystem());
    }

    public static WikiPage makeRoot(String name, Properties properties, MemoryFileSystem fileSystem) {
        WikiPageFactory factory = InMemoryPage.newInstance(fileSystem);
        return factory.makePage(new File("."), name, null, new SystemVariableSource(properties));
    }

    public static WikiPageFactory newInstance() {
        MemoryFileSystem fileSystem = new MemoryFileSystem();
        return InMemoryPage.newInstance(fileSystem);
    }

    public static WikiPageFactory newInstance(FileSystem fileSystem) {
        return new FileSystemPageFactory(fileSystem, new MemoryVersionsController(fileSystem));
    }
}

