/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.ConfigurationParameter;
import fitnesse.components.ComponentFactory;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageFactory;
import fitnesse.wiki.WikiPageFactoryRegistry;
import fitnesse.wiki.fs.DiskFileSystem;
import fitnesse.wiki.fs.ExternalSuitePageFactory;
import fitnesse.wiki.fs.FileBasedWikiPage;
import fitnesse.wiki.fs.FileSystem;
import fitnesse.wiki.fs.FileSystemPage;
import fitnesse.wiki.fs.FileSystemSubWikiPageFactory;
import fitnesse.wiki.fs.VersionsController;
import fitnesse.wiki.fs.WikiFilePage;
import fitnesse.wiki.fs.ZipFileVersionsController;
import fitnesse.wikitext.parser.Maybe;
import fitnesse.wikitext.parser.VariableSource;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class FileSystemPageFactory
implements WikiPageFactory,
WikiPageFactoryRegistry {
    private final FileSystem fileSystem;
    private final VersionsController versionsController;
    private final List<WikiPageFactory> wikiPageFactories = new ArrayList<WikiPageFactory>();
    private final WikiPageFactory fallbackPageFactory;

    public FileSystemPageFactory() {
        this(new DiskFileSystem(), new ZipFileVersionsController());
    }

    public FileSystemPageFactory(Properties properties) {
        this(new ComponentFactory(properties));
    }

    public FileSystemPageFactory(ComponentFactory componentFactory) {
        this(new DiskFileSystem(), componentFactory.createComponent(ConfigurationParameter.VERSIONS_CONTROLLER_CLASS, ZipFileVersionsController.class));
    }

    public FileSystemPageFactory(FileSystem fileSystem, VersionsController versionsController) {
        this(fileSystem, versionsController, RootWikiFilePageFactory.class);
    }

    protected FileSystemPageFactory(FileSystem fileSystem, VersionsController versionsController, Class<? extends WikiPageFactory> fallbackPageFactoryClass) {
        this.fileSystem = fileSystem;
        this.versionsController = versionsController;
        this.fallbackPageFactory = this.instantiateFallbackPageFactory(fallbackPageFactoryClass);
        this.initializeWikiPageFactories();
    }

    private WikiPageFactory instantiateFallbackPageFactory(Class<? extends WikiPageFactory> fallbackPageFactoryClass) {
        try {
            Constructor<? extends WikiPageFactory> ctor = fallbackPageFactoryClass.getDeclaredConstructor(FileSystemPageFactory.class);
            return ctor.newInstance(this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Cannot instantiate wiki page factory", e);
        }
    }

    private void initializeWikiPageFactories() {
        this.registerWikiPageFactory(new InnerFileSystemPageFactory());
        this.registerWikiPageFactory(new WikiFilePageFactory());
        this.registerWikiPageFactory(new ChildWikiFilePageFactory());
        this.registerWikiPageFactory(new RootWikiFilePageFactory());
        this.registerWikiPageFactory(new ExternalSuitePageFactory(this.fileSystem));
    }

    @Override
    public void registerWikiPageFactory(WikiPageFactory wikiPageFactory) {
        this.wikiPageFactories.add(wikiPageFactory);
    }

    @Override
    public boolean supports(File path) {
        for (WikiPageFactory factory : this.wikiPageFactories) {
            if (!factory.supports(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public WikiPage makePage(File path, String pageName, WikiPage parent, VariableSource variableSource) {
        for (WikiPageFactory factory : this.wikiPageFactories) {
            if (!factory.supports(path)) continue;
            return factory.makePage(path, pageName, parent, variableSource);
        }
        if (parent == null || parent instanceof FileBasedWikiPage && this.isWikiWordDirectory(path)) {
            return this.fallbackPageFactory.makePage(path, pageName, parent, variableSource);
        }
        return null;
    }

    private boolean isWikiWordDirectory(File path) {
        return this.fileSystem.isDirectory(path) && PathParser.isSingleWikiWord(path.getName());
    }

    VersionsController getVersionsController() {
        return this.versionsController;
    }

    protected class RootWikiFilePageFactory
    implements WikiPageFactory {
        protected RootWikiFilePageFactory() {
        }

        @Override
        public WikiPage makePage(File path, String pageName, WikiPage parent, VariableSource variableSource) {
            Maybe<String> rootPath = variableSource.findVariable("FITNESSE_ROOTPATH");
            return new WikiFilePage(new File(path, "_root.wiki"), pageName, parent, null, FileSystemPageFactory.this.versionsController, new FileSystemSubWikiPageFactory(new File(rootPath.getValue()), FileSystemPageFactory.this.fileSystem, variableSource, FileSystemPageFactory.this), variableSource);
        }

        @Override
        public boolean supports(File path) {
            File rootWikiFile = new File(path, "_root.wiki");
            return FileSystemPageFactory.this.fileSystem.exists(rootWikiFile) && !FileSystemPageFactory.this.fileSystem.isDirectory(rootWikiFile);
        }
    }

    protected class ChildWikiFilePageFactory
    implements WikiPageFactory {
        protected ChildWikiFilePageFactory() {
        }

        @Override
        public WikiPage makePage(File path, String pageName, WikiPage parent, VariableSource variableSource) {
            Maybe<String> rootPath = variableSource.findVariable("FITNESSE_ROOTPATH");
            return new WikiFilePage(this.wikiFile(path), pageName, parent, null, FileSystemPageFactory.this.versionsController, new FileSystemSubWikiPageFactory(new File(rootPath.getValue()), FileSystemPageFactory.this.fileSystem, variableSource, FileSystemPageFactory.this), variableSource);
        }

        private File wikiFile(File path) {
            return new File(path.getPath() + ".wiki");
        }

        @Override
        public boolean supports(File path) {
            File wikiFile = this.wikiFile(path);
            return FileSystemPageFactory.this.fileSystem.exists(wikiFile) && !FileSystemPageFactory.this.fileSystem.isDirectory(wikiFile);
        }
    }

    protected class WikiFilePageFactory
    implements WikiPageFactory {
        protected WikiFilePageFactory() {
        }

        @Override
        public WikiPage makePage(File path, String pageName, WikiPage parent, VariableSource variableSource) {
            Maybe<String> rootPath = variableSource.findVariable("FITNESSE_ROOTPATH");
            return new WikiFilePage(path, pageName.substring(0, pageName.length() - ".wiki".length()), parent, null, FileSystemPageFactory.this.versionsController, new FileSystemSubWikiPageFactory(new File(rootPath.getValue()), FileSystemPageFactory.this.fileSystem, variableSource, FileSystemPageFactory.this), variableSource);
        }

        @Override
        public boolean supports(File path) {
            return path.getPath().endsWith(".wiki") && !"_root.wiki".equals(path.getName()) && FileSystemPageFactory.this.fileSystem.exists(path) && !FileSystemPageFactory.this.fileSystem.isDirectory(path);
        }
    }

    protected class InnerFileSystemPageFactory
    implements WikiPageFactory {
        protected InnerFileSystemPageFactory() {
        }

        @Override
        public WikiPage makePage(File path, String pageName, WikiPage parent, VariableSource variableSource) {
            Maybe<String> rootPath = variableSource.findVariable("FITNESSE_ROOTPATH");
            return new FileSystemPage(path, pageName, parent, null, FileSystemPageFactory.this.versionsController, new FileSystemSubWikiPageFactory(new File(rootPath.getValue()), FileSystemPageFactory.this.fileSystem, variableSource, FileSystemPageFactory.this), variableSource);
        }

        @Override
        public boolean supports(File path) {
            String[] children;
            for (String child : children = FileSystemPageFactory.this.fileSystem.list(path)) {
                if (!child.equals("content.txt")) continue;
                return true;
            }
            return false;
        }
    }
}

