/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.wiki.BaseWikitextPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageLoadException;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.fs.FileBasedWikiPage;
import fitnesse.wiki.fs.FileVersion;
import fitnesse.wiki.fs.SubWikiPageFactory;
import fitnesse.wiki.fs.VersionsController;
import fitnesse.wiki.fs.WikiFilePage;
import fitnesse.wiki.fs.WikiPageProperties;
import fitnesse.wikitext.parser.VariableSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import util.FileUtil;

public class FileSystemPage
extends BaseWikitextPage
implements FileBasedWikiPage {
    static final String contentFilename = "content.txt";
    static final String propertiesFilename = "properties.xml";
    private final File path;
    private final transient VersionsController versionsController;
    private final transient SubWikiPageFactory subWikiPageFactory;
    private final String versionName;
    private transient PageData pageData;

    public FileSystemPage(File path, String name, VersionsController versionsController, SubWikiPageFactory subWikiPageFactory, VariableSource variableSource) {
        super(name, variableSource);
        this.path = path;
        this.versionsController = versionsController;
        this.subWikiPageFactory = subWikiPageFactory;
        this.versionName = null;
    }

    private FileSystemPage(File path, String name, FileSystemPage parent) {
        this(path, name, parent, null, parent.versionsController, parent.subWikiPageFactory, parent.getVariableSource());
    }

    private FileSystemPage(FileSystemPage page, String versionName) {
        this(page.getFileSystemPath(), page.getName(), page.isRoot() ? null : page.getParent(), versionName, page.versionsController, page.subWikiPageFactory, page.getVariableSource());
    }

    protected FileSystemPage(File path, String name, WikiPage parent, String versionName, VersionsController versionsController, SubWikiPageFactory subWikiPageFactory, VariableSource variableSource) {
        super(name, parent, variableSource);
        this.path = path;
        this.versionsController = versionsController;
        this.subWikiPageFactory = subWikiPageFactory;
        this.versionName = versionName;
    }

    @Override
    public void removeChildPage(String name) {
        WikiPage childPage = this.getChildPage(name);
        if (childPage != null) {
            childPage.remove();
        }
    }

    @Override
    public void remove() {
        try {
            this.versionsController.delete(this.getFileSystemPath());
        }
        catch (IOException e) {
            throw new WikiPageLoadException(String.format("Could not remove page %s", new WikiPagePath(this).toString()), e);
        }
    }

    @Override
    public WikiPage addChildPage(String pageName) {
        WikiPage page = this.getChildPage(pageName);
        if (page == null) {
            page = this.createPage(pageName);
        }
        return page;
    }

    private WikiPage createPage(String pageName) {
        if ("true".equalsIgnoreCase(this.getVariable("wiki.page.old.style"))) {
            return new FileSystemPage(new File(this.getFileSystemPath(), pageName), pageName, this);
        }
        return new WikiFilePage(new File(this.getFileSystemPath(), pageName + ".wiki"), pageName, this, null, this.versionsController, this.subWikiPageFactory, this.getVariableSource());
    }

    @Override
    public List<WikiPage> getChildren() {
        return this.subWikiPageFactory.getChildren(this);
    }

    @Override
    public WikiPage getChildPage(String childName) {
        return this.subWikiPageFactory.getChildPage(this, childName);
    }

    @Override
    public PageData getData() {
        if (this.pageData == null) {
            try {
                this.pageData = this.getDataVersion();
            }
            catch (IOException e) {
                throw new WikiPageLoadException("Could not load page data for page " + this.path.getPath(), e);
            }
        }
        return new PageData(this.pageData);
    }

    @Override
    public File getFileSystemPath() {
        return this.path;
    }

    @Override
    public VersionInfo commit(PageData data) {
        this.resetCache();
        try {
            return this.versionsController.makeVersion(new ContentFileVersion(data), new PropertiesFileVersion(data));
        }
        catch (IOException e) {
            throw new WikiPageLoadException(e);
        }
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.pageData = null;
    }

    @Override
    public Collection<VersionInfo> getVersions() {
        return this.versionsController.history(this.contentFile(), this.propertiesFile());
    }

    private PageData getDataVersion() throws IOException {
        FileVersion[] versions = this.versionsController.getRevisionData(this.versionName, this.contentFile(), this.propertiesFile());
        String content = "";
        WikiPageProperty properties = null;
        try {
            for (FileVersion version : versions) {
                if (version == null) continue;
                if (contentFilename.equals(version.getFile().getName())) {
                    content = this.loadContent(version);
                    continue;
                }
                if (!propertiesFilename.equals(version.getFile().getName())) continue;
                properties = this.loadAttributes(version);
            }
        }
        catch (IOException e) {
            throw new WikiPageLoadException(e);
        }
        if (properties == null) {
            properties = this.defaultPageProperties();
        }
        return new PageData(content, properties);
    }

    @Override
    public WikiPage getVersion(String versionName) {
        try {
            this.versionsController.getRevisionData(versionName, this.contentFile(), this.propertiesFile());
        }
        catch (IOException e) {
            throw new WikiPageLoadException(String.format("Could not load version %s for page at %s", versionName, this.path.getPath()), e);
        }
        return new FileSystemPage(this, versionName);
    }

    @Override
    public String toString() {
        try {
            return this.getClass().getName() + " at " + this.getFileSystemPath() + "#" + (this.versionName != null ? this.versionName : "latest");
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    private File contentFile() {
        return new File(this.getFileSystemPath(), contentFilename);
    }

    private File propertiesFile() {
        return new File(this.getFileSystemPath(), propertiesFilename);
    }

    private String loadContent(FileVersion fileVersion) throws IOException {
        try (InputStream content = fileVersion.getContent();){
            String string = FileUtil.toString(content);
            return string;
        }
    }

    private WikiPageProperties loadAttributes(FileVersion fileVersion) throws IOException {
        WikiPageProperties props = new WikiPageProperties();
        try (InputStream content = fileVersion.getContent();){
            props.loadFromXmlStream(content);
        }
        props.setLastModificationTime(fileVersion.getLastModificationTime());
        return props;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileSystemPage)) {
            return false;
        }
        FileSystemPage that = (FileSystemPage)other;
        return this.versionName != null ? this.versionName.equals(that.versionName) : that.versionName == null && super.equals(that);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.versionName != null ? this.versionName.hashCode() : 0);
        return result;
    }

    class PropertiesFileVersion
    implements FileVersion {
        final PageData data;

        PropertiesFileVersion(PageData pageData) {
            this.data = new PageData(pageData);
        }

        @Override
        public File getFile() {
            return FileSystemPage.this.propertiesFile();
        }

        @Override
        public InputStream getContent() throws IOException {
            WikiPageProperties propertiesToSave = new WikiPageProperties(this.data.getProperties());
            this.removeAlwaysChangingProperties(propertiesToSave);
            return new ByteArrayInputStream(propertiesToSave.toXml().getBytes(FileUtil.CHARENCODING));
        }

        @Override
        public String getAuthor() {
            return this.data.getAttribute("LastModifyingUser");
        }

        @Override
        public Date getLastModificationTime() {
            return this.data.getProperties().getLastModificationTime();
        }

        private void removeAlwaysChangingProperties(WikiPageProperties properties) {
            properties.remove("LastModified");
        }
    }

    class ContentFileVersion
    implements FileVersion {
        final PageData data;

        ContentFileVersion(PageData pageData) {
            this.data = new PageData(pageData);
        }

        @Override
        public File getFile() {
            return FileSystemPage.this.contentFile();
        }

        @Override
        public InputStream getContent() throws UnsupportedEncodingException {
            String content = this.data.getContent();
            if (content == null) {
                return new ByteArrayInputStream("".getBytes());
            }
            String separator = System.getProperty("line.separator");
            if (content.endsWith("|")) {
                content = content + separator;
            }
            content = content.replaceAll("\r\n", "\n");
            content = content.replaceAll("\n", separator);
            return new ByteArrayInputStream(content.getBytes(FileUtil.CHARENCODING));
        }

        @Override
        public String getAuthor() {
            return this.data.getAttribute("LastModifyingUser");
        }

        @Override
        public Date getLastModificationTime() {
            return this.data.getProperties().getLastModificationTime();
        }
    }
}

