/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SymbolUtil {
    public static List<Symbol> findSymbolsByType(Symbol syntaxTree, SymbolType type, boolean preorder) {
        LinkedList<Symbol> symbols = new LinkedList<Symbol>();
        if (preorder) {
            SymbolUtil.addToSymbolsIfIsOfType(symbols, syntaxTree, type);
        }
        for (Symbol subTree : syntaxTree.getChildren()) {
            symbols.addAll(SymbolUtil.findSymbolsByType(subTree, type, preorder));
        }
        if (!preorder) {
            SymbolUtil.addToSymbolsIfIsOfType(symbols, syntaxTree, type);
        }
        return Collections.unmodifiableList(symbols);
    }

    private static void addToSymbolsIfIsOfType(List<Symbol> symbols, Symbol symbol, SymbolType type) {
        if (type == null) {
            symbols.add(symbol);
        } else if (symbol.isType(type)) {
            symbols.add(symbol);
        }
    }
}

