/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.PageCrawlerDeadEndStrategy;
import fitnesse.wiki.PagePruningStrategy;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class PageCrawler {
    private final WikiPage context;

    public PageCrawler(WikiPage context) {
        this.context = context;
    }

    public WikiPage getPage(WikiPagePath path) {
        return this.getPage(path, null);
    }

    public WikiPage getPage(WikiPagePath path, PageCrawlerDeadEndStrategy deadEndStrategy) {
        return this.getPage(this.context, path, deadEndStrategy);
    }

    private WikiPage getPage(WikiPage page, WikiPagePath path, PageCrawlerDeadEndStrategy deadEndStrategy) {
        if (path == null) {
            return null;
        }
        if (this.isRoot(path)) {
            return this.getRoot(page);
        }
        if (path.isEmpty()) {
            return page;
        }
        if (path.isAbsolute()) {
            WikiPagePath relativeToRoot = new WikiPagePath(path);
            relativeToRoot.setPathMode(WikiPagePath.Mode.RELATIVE);
            return this.getPage(this.getRoot(page), relativeToRoot, deadEndStrategy);
        }
        if (path.isBackwardSearchPath()) {
            return this.getSiblingPage(page, path);
        }
        String firstPathElement = path.getFirst();
        WikiPagePath restOfPath = path.getRest();
        WikiPage childPage = page.getChildPage(firstPathElement);
        if (childPage != null) {
            return this.getPage(childPage, restOfPath, deadEndStrategy);
        }
        return this.getPageAfterDeadEnd(page, firstPathElement, restOfPath, deadEndStrategy);
    }

    private boolean isRoot(WikiPagePath path) {
        return path.isAbsolute() && path.isEmpty();
    }

    private WikiPage getPageAfterDeadEnd(WikiPage page, String first, WikiPagePath rest, PageCrawlerDeadEndStrategy deadEndStrategy) {
        rest.addNameToFront(first);
        if (deadEndStrategy != null) {
            return deadEndStrategy.getPageAfterDeadEnd(page, rest, this);
        }
        return null;
    }

    public boolean pageExists(WikiPagePath path) {
        return this.getPage(path) != null;
    }

    public WikiPagePath getFullPathOfChild(WikiPagePath childPath) {
        WikiPagePath fullPathOfChild;
        if (childPath.isAbsolute()) {
            fullPathOfChild = childPath.relativePath();
        } else {
            WikiPagePath absolutePathOfParent = new WikiPagePath(this.context);
            fullPathOfChild = absolutePathOfParent.append(childPath);
        }
        return fullPathOfChild;
    }

    public WikiPagePath getFullPath() {
        return new WikiPagePath(this.context);
    }

    public String getRelativeName(WikiPage page) {
        StringBuilder name = new StringBuilder();
        WikiPage p = page;
        while (!p.isRoot() && !p.equals(this.context)) {
            if (p != page) {
                name.insert(0, ".");
            }
            name.insert(0, p.getName());
            p = p.getParent();
        }
        return name.toString();
    }

    public WikiPage getClosestInheritedPage(final String pageName) {
        final WikiPage[] foundPage = new WikiPage[1];
        this.traversePageAndAncestors((TraversalListener<? super WikiPage>)new TraversalListener<WikiPage>(){

            @Override
            public void process(WikiPage page) {
                WikiPage namedPage = page.getChildPage(pageName);
                if (namedPage != null && foundPage[0] == null) {
                    foundPage[0] = namedPage;
                }
            }
        });
        return foundPage[0];
    }

    public WikiPage getRoot() {
        return this.getRoot(this.context);
    }

    private WikiPage getRoot(WikiPage page) {
        if (page.isRoot()) {
            return page;
        }
        return this.getRoot(page.getParent());
    }

    public void traverse(TraversalListener<? super WikiPage> listener, PagePruningStrategy strategy) {
        this.traverse(this.context, listener, strategy);
    }

    private void traverse(WikiPage page, TraversalListener<? super WikiPage> listener, PagePruningStrategy pruningStrategy) {
        if (pruningStrategy.skipPageAndChildren(page)) {
            return;
        }
        listener.process(page);
        for (WikiPage wikiPage : page.getChildren()) {
            this.traverse(wikiPage, listener, pruningStrategy);
        }
    }

    public WikiPage getSiblingPage(WikiPagePath pathRelativeToSibling) {
        return this.getSiblingPage(this.context, pathRelativeToSibling);
    }

    private WikiPage getSiblingPage(WikiPage page, WikiPagePath pathRelativeToSibling) {
        if (pathRelativeToSibling.isSubPagePath()) {
            WikiPagePath relativePath = new WikiPagePath(pathRelativeToSibling);
            relativePath.setPathMode(WikiPagePath.Mode.RELATIVE);
            return this.getPage(relativePath);
        }
        if (pathRelativeToSibling.isBackwardSearchPath()) {
            String target = pathRelativeToSibling.getFirst();
            WikiPage ancestor = this.findAncestorWithName(target);
            if (ancestor != null) {
                return this.getPage(ancestor, pathRelativeToSibling.getRest(), null);
            }
            WikiPagePath absolutePath = new WikiPagePath(pathRelativeToSibling);
            absolutePath.makeAbsolute();
            WikiPage root = this.getRoot(page);
            return this.getPage(root, absolutePath, null);
        }
        WikiPage parent = page.getParent();
        return this.getPage(parent, pathRelativeToSibling, null);
    }

    public WikiPage findAncestorWithName(String name) {
        WikiPage current = this.context.getParent();
        while (!current.isRoot()) {
            if (current.getName().equals(name)) {
                return current;
            }
            current = current.getParent();
        }
        return null;
    }

    public void traverseUncles(final String uncleName, final TraversalListener<? super WikiPage> callback) {
        this.traversePageAndAncestors((TraversalListener<? super WikiPage>)new TraversalListener<WikiPage>(){

            @Override
            public void process(WikiPage page) {
                WikiPage namedPage = page.getChildPage(uncleName);
                if (namedPage != null) {
                    callback.process(namedPage);
                }
            }
        });
    }

    public void traversePageAndAncestors(TraversalListener<? super WikiPage> callback) {
        WikiPage page = this.context;
        while (!page.isRoot()) {
            callback.process(page);
            page = page.getParent();
        }
        callback.process(page);
    }
}

