/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.util;

import fitnesse.util.Clock;
import java.util.Date;

public class DateAlteringClock
extends Clock {
    private long rebaseToTime;
    private final long baseSystemTime;
    private boolean frozen;
    private boolean advanceOnEachQuery;

    public DateAlteringClock(Date rebaseToDate) {
        super(true);
        this.rebaseToTime = rebaseToDate.getTime();
        this.baseSystemTime = SYSTEM_CLOCK.currentClockTimeInMillis();
    }

    @Override
    public long currentClockTimeInMillis() {
        if (this.frozen) {
            return this.rebaseToTime;
        }
        if (this.advanceOnEachQuery) {
            return ++this.rebaseToTime;
        }
        return this.rebaseToTime + SYSTEM_CLOCK.currentClockTimeInMillis() - this.baseSystemTime;
    }

    public DateAlteringClock freeze() {
        this.frozen = true;
        return this;
    }

    public DateAlteringClock elapse(long ms) {
        this.rebaseToTime += ms;
        return this;
    }

    public DateAlteringClock advanceMillisOnEachQuery() {
        this.advanceOnEachQuery = true;
        return this;
    }
}

