/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.updates.Update;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class FileUpdate
implements Update {
    protected final File destination;
    protected final String source;
    protected final String filename;

    public FileUpdate(String source, File destination) {
        this.destination = destination;
        this.source = source;
        this.filename = new File(source).getName();
    }

    @Override
    public void doUpdate() throws IOException {
        this.makeSureDirectoriesExist();
        this.copyResource();
    }

    private void makeSureDirectoriesExist() {
        this.destination.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource() throws IOException {
        URL url = this.getResource(this.source);
        if (url != null) {
            InputStream input = null;
            OutputStream output = null;
            try {
                int b;
                input = url.openStream();
                output = new FileOutputStream(this.destinationFile());
                while ((b = input.read()) != -1) {
                    output.write(b);
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
            }
        } else {
            throw new FileNotFoundException("Could not load resource: " + this.source);
        }
    }

    protected URL getResource(String resource) {
        return this.getClass().getClassLoader().getResource(resource);
    }

    @Override
    public String getMessage() {
        return ".";
    }

    protected File destinationFile() {
        return new File(this.destination, this.filename);
    }

    @Override
    public String getName() {
        return "FileUpdate(" + this.filename + ")";
    }

    @Override
    public boolean shouldBeApplied() throws IOException {
        return !this.destinationFile().exists();
    }
}

