/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.SlimExceptionResult;
import fitnesse.testsystems.slim.results.SlimTestResult;
import fitnesse.testsystems.slim.tables.SlimAssertion;
import fitnesse.testsystems.slim.tables.SlimExpectation;
import fitnesse.testsystems.slim.tables.SlimTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TableTable
extends SlimTable {
    public TableTable(Table table, String tableId, SlimTestContext slimTestContext) {
        super(table, tableId, slimTestContext);
    }

    @Override
    protected String getTableType() {
        return "tableTable";
    }

    @Override
    public List<SlimAssertion> getAssertions() {
        SlimAssertion make = this.constructFixture(this.getFixtureName());
        Instruction doTable = this.callFunction(this.getTableName(), "doTable", this.tableAsList());
        return Arrays.asList(make, this.makeAssertion(doTable, new TableTableExpectation()));
    }

    private TestSummary resizeTableAndEvaluateRows(Object returnValue) {
        List tableResults = (List)returnValue;
        this.extendTable(this.table, tableResults);
        TestSummary testSummary = new TestSummary();
        for (int row = 0; row < tableResults.size(); ++row) {
            this.evaluateRow(tableResults, row, testSummary);
        }
        return testSummary;
    }

    private void extendTable(Table table, List<List<Object>> tableResults) {
        this.addNewRows(table, tableResults);
        this.extendExistingRows(table, tableResults);
    }

    private void addNewRows(Table table, List<List<Object>> tableResults) {
        while (table.getRowCount() - 1 < tableResults.size()) {
            ArrayList<String> l = new ArrayList<String>();
            for (Object s : tableResults.get(table.getRowCount() - 1)) {
                l.add((String)s);
            }
            table.addRow(l);
        }
    }

    private void extendExistingRows(Table table, List<List<Object>> tableResults) {
        for (int row = 1; row < table.getRowCount(); ++row) {
            this.extendRow(table, row, tableResults.get(row - 1));
        }
    }

    private void extendRow(Table table, int row, List<Object> cellList) {
        while (table.getColumnCountInRow(row) < cellList.size()) {
            table.addColumnToRow(row, (String)cellList.get(table.getColumnCountInRow(row)));
        }
    }

    private void evaluateRow(List<List<Object>> tableResults, int resultRow, TestSummary testSummary) {
        List<Object> rowList = tableResults.get(resultRow);
        for (int col = 0; col < rowList.size(); ++col) {
            int tableRow = resultRow + 1;
            String contents = this.table.getCellContents(col, tableRow);
            String result = (String)rowList.get(col);
            SlimTestResult testResult = this.getTestResult(result, this.replaceSymbolsWithFullExpansion(contents));
            this.table.updateContent(col, tableRow, testResult);
            testSummary.add(testResult.getExecutionResult());
        }
    }

    private SlimTestResult getTestResult(String message, String content) {
        SlimTestResult result = message.equalsIgnoreCase("no change") || message.isEmpty() ? SlimTestResult.plain(content) : (message.equalsIgnoreCase("pass") ? SlimTestResult.pass(content) : (message.equalsIgnoreCase("fail") ? SlimTestResult.fail(content) : (message.equalsIgnoreCase("ignore") ? SlimTestResult.ignore(content) : this.resultFromMessage(message, content))));
        return result;
    }

    private SlimTestResult resultFromMessage(String codeAndMessage, String content) {
        int colon = codeAndMessage.indexOf(":");
        if (colon == -1) {
            return SlimTestResult.fail(this.manageSymbolInContent(content, codeAndMessage));
        }
        String code = codeAndMessage.substring(0, colon);
        String message = codeAndMessage.substring(colon + 1);
        message = this.manageSymbolInContent(content, message);
        if (code.equalsIgnoreCase("error")) {
            return SlimTestResult.error(message);
        }
        if (code.equalsIgnoreCase("fail")) {
            return SlimTestResult.fail(message);
        }
        if (code.equalsIgnoreCase("pass")) {
            return SlimTestResult.pass(message);
        }
        if (code.equalsIgnoreCase("ignore")) {
            return SlimTestResult.ignore(message);
        }
        if (code.equalsIgnoreCase("report")) {
            return SlimTestResult.plain(message);
        }
        return SlimTestResult.fail(this.manageSymbolInContent(content, codeAndMessage));
    }

    private String manageSymbolInContent(String content, String message) {
        String symbolName = this.isSymbolAssignment(content);
        if (symbolName != null) {
            this.setSymbol(symbolName, message, true);
            message = String.format("$%s<-[%s]", symbolName, message);
        }
        return message;
    }

    public class TableTableExpectation
    implements SlimExpectation {
        @Override
        public TestResult evaluateExpectation(Object tableReturn) {
            SlimTestResult testResult;
            if (tableReturn == null || "null".equals(tableReturn)) {
                testResult = SlimTestResult.ignore("No results from table");
                TableTable.this.table.updateContent(TableTable.this.table.getColumnCountInRow(0) - 1, 0, testResult);
            } else if (tableReturn instanceof String) {
                testResult = SlimTestResult.error((String)tableReturn);
                TableTable.this.table.updateContent(0, 0, testResult);
            } else {
                TestSummary testSummary = TableTable.this.resizeTableAndEvaluateRows(tableReturn);
                TableTable.this.getTestContext().increment(testSummary);
                testResult = new SlimTestResult(ExecutionResult.getExecutionResult(testSummary));
                testResult.setVariables(TableTable.this.getSymbolsToStore());
            }
            TableTable.this.getTestContext().increment(testResult.getExecutionResult());
            return testResult;
        }

        @Override
        public SlimExceptionResult evaluateException(SlimExceptionResult exceptionResult) {
            TableTable.this.table.updateContent(0, 0, exceptionResult);
            TableTable.this.getTestContext().incrementErroredTestsCount();
            return exceptionResult;
        }
    }
}

