/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.BaselineDecisionTable;
import fitnesse.testsystems.slim.tables.DecisionTable;
import fitnesse.testsystems.slim.tables.Disgracer;
import fitnesse.testsystems.slim.tables.DynamicDecisionTable;
import fitnesse.testsystems.slim.tables.ImportTable;
import fitnesse.testsystems.slim.tables.LibraryTable;
import fitnesse.testsystems.slim.tables.OrderedQueryTable;
import fitnesse.testsystems.slim.tables.QueryTable;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.ScriptTable;
import fitnesse.testsystems.slim.tables.ScriptTableWithVerify;
import fitnesse.testsystems.slim.tables.SlimErrorTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SubsetQueryTable;
import fitnesse.testsystems.slim.tables.TableCreationException;
import fitnesse.testsystems.slim.tables.TableTable;
import fitnesse.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SlimTableFactory {
    private static final Logger LOG = Logger.getLogger(SlimTableFactory.class.getName());
    private static final Map<Class<? extends SlimTable>, Constructor<? extends SlimTable>> CONSTRUCTOR_MAP = new HashMap<Class<? extends SlimTable>, Constructor<? extends SlimTable>>();
    private final Map<String, Class<? extends SlimTable>> tableTypes;
    private final Map<String, String> tableTypeArrays;
    private final Map<String, String> aliasArrays;

    public SlimTableFactory() {
        this.tableTypes = new HashMap<String, Class<? extends SlimTable>>(16);
        this.tableTypeArrays = new HashMap<String, String>();
        this.aliasArrays = new HashMap<String, String>();
        this.addTableType("dt", DecisionTable.class);
        this.addTableType("decision", DecisionTable.class);
        this.addTableType("ddt", DynamicDecisionTable.class);
        this.addTableType("dynamic decision", DynamicDecisionTable.class);
        this.addTableType("ordered query", OrderedQueryTable.class);
        this.addTableType("subset query", SubsetQueryTable.class);
        this.addTableType("query", QueryTable.class);
        this.addTableType("table", TableTable.class);
        this.addTableType("script", ScriptTable.class);
        this.addTableType("script:", ScriptTable.class);
        this.addTableType("verify script", ScriptTableWithVerify.class);
        this.addTableType("scenario", ScenarioTable.class);
        this.addTableType("import", ImportTable.class);
        this.addTableType("library", LibraryTable.class);
        this.addTableType("baseline", BaselineDecisionTable.class);
    }

    protected SlimTableFactory(Map<String, Class<? extends SlimTable>> tableTypes, Map<String, String> tableTypeArrays, Map<String, String> aliasArrays) {
        this.tableTypes = tableTypes;
        this.tableTypeArrays = tableTypeArrays;
        this.aliasArrays = aliasArrays;
    }

    public void addTableType(String nameOrPrefix, Class<? extends SlimTable> tableClass) {
        if (this.tableTypes.get(nameOrPrefix) != null) {
            throw new IllegalStateException("A table type named '" + nameOrPrefix + "' already exists");
        }
        this.tableTypes.put(nameOrPrefix.toLowerCase().replaceAll(":", ""), tableClass);
    }

    public SlimTable makeSlimTable(Table table, String tableId, SlimTestContext slimTestContext) {
        TableTypeAndName nameAndType = this.getTableNameAndType(table.getCellContents(0, 0));
        if (nameAndType.hasTableName("define alias")) {
            this.parseDefineAliasTable(table);
            return null;
        }
        if (nameAndType.hasTableName("define table type")) {
            this.parseDefineTableTypeTable(table);
            return null;
        }
        if (nameAndType.hasTableType("comment") || nameAndType.hasTableName("comment")) {
            return null;
        }
        Class<? extends SlimTable> tableClass = this.getTableType(nameAndType.tableType);
        SlimTable newTable = tableClass != null ? this.newTableForType(tableClass, table, tableId, slimTestContext) : (nameAndType.mayBeDecisionTable() ? new DecisionTable(table, tableId, slimTestContext) : new SlimErrorTable(table, tableId, slimTestContext));
        newTable.setFixtureName(nameAndType.tableName);
        return newTable;
    }

    private boolean hasColon(String tableType) {
        return tableType.contains(":");
    }

    public Class<? extends SlimTable> getTableType(String tableType) {
        return this.tableTypes.get(tableType.toLowerCase().trim());
    }

    private SlimTable newTableForType(Class<? extends SlimTable> tableClass, Table table, String tableId, SlimTestContext slimTestContext) {
        try {
            return SlimTableFactory.createTable(tableClass, table, tableId, slimTestContext);
        }
        catch (TableCreationException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
            return new SlimErrorTable(table, tableId, slimTestContext);
        }
    }

    public static <T extends SlimTable> T createTable(Class<T> tableClass, Table table, String tableId, SlimTestContext slimTestContext) throws TableCreationException {
        Constructor<SlimTable> constructor = CONSTRUCTOR_MAP.get(tableClass);
        try {
            if (constructor == null) {
                constructor = tableClass.getConstructor(Table.class, String.class, SlimTestContext.class);
                CONSTRUCTOR_MAP.put(tableClass, constructor);
            }
            return (T)constructor.newInstance(table, tableId, slimTestContext);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TableCreationException("Can not create new table instance for class " + tableClass.getName(), e);
        }
    }

    private TableTypeAndName getTableNameAndType(String tableName) {
        TableTypeAndName nameAndType = this.hasColon(tableName) ? new TableTypeAndName(tableName.split(":")) : (this.getTableType(tableName) != null ? new TableTypeAndName(tableName, "") : new TableTypeAndName("", tableName));
        String disgracedName = Disgracer.disgraceClassName(nameAndType.tableName);
        if (this.aliasArrays.containsKey(disgracedName)) {
            String aliasedTableName = this.aliasArrays.get(disgracedName);
            if (this.hasColon(aliasedTableName)) {
                String[] aliasParts = aliasedTableName.split(":");
                return new TableTypeAndName(aliasParts[0].isEmpty() ? nameAndType.tableType : aliasParts[0], aliasParts.length <= 1 || aliasParts[1].isEmpty() ? nameAndType.tableName : aliasParts[1]);
            }
            return new TableTypeAndName(nameAndType.tableType, aliasedTableName);
        }
        if (StringUtils.isBlank(nameAndType.tableType) && this.tableTypeArrays.containsKey(disgracedName)) {
            return new TableTypeAndName(this.tableTypeArrays.get(disgracedName), nameAndType.tableName);
        }
        return nameAndType;
    }

    private void parseDefineTableTypeTable(Table table) {
        for (int rowIndex = 1; rowIndex < table.getRowCount(); ++rowIndex) {
            this.parseDefineTableTypeRow(table, rowIndex);
        }
    }

    private void parseDefineTableTypeRow(Table table, int rowIndex) {
        if (table.getColumnCountInRow(rowIndex) >= 2) {
            String fixtureName = table.getCellContents(0, rowIndex);
            String fixture = Disgracer.disgraceClassName(fixtureName);
            String tableSpecifier = table.getCellContents(1, rowIndex).toLowerCase();
            this.tableTypeArrays.put(fixture, this.makeTableType(tableSpecifier));
        }
    }

    public void addDefaultTableType(String fixture, String tableType) {
        this.tableTypeArrays.put(fixture, tableType);
    }

    public void addAlias(String alias, String fixture) {
        String disgracedAlias = Disgracer.disgraceClassName(alias);
        this.aliasArrays.put(disgracedAlias, fixture);
    }

    private String makeTableType(String tableSpecifier) {
        if ((tableSpecifier = tableSpecifier.replace(':', ' ')).startsWith("as")) {
            tableSpecifier = tableSpecifier.substring(2);
        }
        return tableSpecifier.trim();
    }

    private void parseDefineAliasTable(Table table) {
        for (int rowIndex = 1; rowIndex < table.getRowCount(); ++rowIndex) {
            this.parseDefineAliasRow(table, rowIndex);
        }
    }

    private void parseDefineAliasRow(Table table, int rowIndex) {
        if (table.getColumnCountInRow(rowIndex) >= 2) {
            String fixtureName = table.getCellContents(0, rowIndex);
            String tableSpecifier = table.getCellContents(1, rowIndex).trim();
            this.addAlias(fixtureName, tableSpecifier);
        }
    }

    public SlimTableFactory copy() {
        return new SlimTableFactory(new HashMap<String, Class<? extends SlimTable>>(this.tableTypes), new HashMap<String, String>(this.tableTypeArrays), new HashMap<String, String>(this.aliasArrays));
    }

    private static class TableTypeAndName {
        private String tableType;
        private String tableName;

        private TableTypeAndName(String tableType, String tableName) {
            this.tableType = tableType.toLowerCase().trim();
            this.tableName = tableName.trim();
        }

        private TableTypeAndName(String[] typeAndName) {
            this(typeAndName[0], typeAndName.length > 1 ? typeAndName[1] : "");
        }

        private boolean hasTableType(String name) {
            return this.tableType.equalsIgnoreCase(name);
        }

        private boolean hasTableName(String name) {
            return this.tableName.equalsIgnoreCase(name);
        }

        private boolean mayBeDecisionTable() {
            return StringUtils.isBlank(this.tableType) && !StringUtils.isBlank(this.tableName);
        }
    }
}

