/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.TestExecutionException;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.SlimTestResult;
import fitnesse.testsystems.slim.tables.Disgracer;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.SlimAssertion;
import fitnesse.testsystems.slim.tables.SlimExpectation;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import fitnesse.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ScriptTable
extends SlimTable {
    public ScriptTable(Table table, String tableId, SlimTestContext context) {
        super(table, tableId, context);
    }

    @Override
    protected String getTableType() {
        return "scriptTable";
    }

    protected String getTableKeyword() {
        return "script";
    }

    protected String getStartKeyword() {
        return "start";
    }

    protected String getCheckKeyword() {
        return "check";
    }

    protected String getCheckNotKeyword() {
        return "check not";
    }

    protected String getRejectKeyword() {
        return "reject";
    }

    protected String getEnsureKeyword() {
        return "ensure";
    }

    protected String getShowKeyword() {
        return "show";
    }

    protected String getNoteKeyword() {
        return "note";
    }

    @Override
    public List<SlimAssertion> getAssertions() throws TestExecutionException {
        ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
        if (this.isTopLevelTable()) {
            this.getTestContext().setCurrentScriptClass(this.getClass());
            List<SlimAssertion> createAssertions = this.startActor();
            if (createAssertions != null) {
                assertions.addAll(createAssertions);
            }
        }
        for (int row = 1; row < this.table.getRowCount(); ++row) {
            assertions.addAll(this.instructionsForRow(row));
        }
        return assertions;
    }

    private boolean isTopLevelTable() {
        return this.getParent() == null;
    }

    protected List<SlimAssertion> instructionsForRow(int row) throws TestExecutionException {
        String match;
        String firstCell = this.table.getCellContents(0, row).trim();
        List<SlimAssertion> assertions = firstCell.equalsIgnoreCase(this.getStartKeyword()) ? this.startActor(row) : (firstCell.equalsIgnoreCase(this.getCheckKeyword()) ? this.checkAction(row) : (firstCell.equalsIgnoreCase(this.getCheckNotKeyword()) ? this.checkNotAction(row) : (firstCell.equalsIgnoreCase(this.getRejectKeyword()) ? this.reject(row) : (firstCell.equalsIgnoreCase(this.getEnsureKeyword()) ? this.ensure(row) : (firstCell.equalsIgnoreCase(this.getShowKeyword()) ? this.show(row) : (firstCell.equalsIgnoreCase(this.getNoteKeyword()) ? this.note(row) : ((match = this.isSymbolAssignment(0, row)) != null ? this.actionAndAssign(match, row) : (firstCell.isEmpty() ? this.note(row) : (firstCell.trim().startsWith("#") || firstCell.trim().startsWith("*") ? this.note(row) : this.action(row))))))))));
        return assertions;
    }

    protected List<SlimAssertion> actionAndAssign(String symbolName, int row) throws SyntaxError {
        ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        String actionName = this.getActionNameStartingAt(1, lastCol, row);
        if (!actionName.equals("")) {
            String[] args = this.getArgumentsStartingAt(2, lastCol, row, assertions);
            assertions.add(this.makeAssertion(this.callAndAssign(symbolName, this.getTableType() + "Actor", actionName, args), new SlimTable.SymbolAssignmentExpectation((SlimTable)this, symbolName, 0, row)));
        }
        return assertions;
    }

    protected List<SlimAssertion> action(int row) throws TestExecutionException {
        List<SlimAssertion> assertions = this.assertionsFromScenario(row);
        if (assertions.isEmpty()) {
            int lastCol = this.table.getColumnCountInRow(row) - 1;
            return this.invokeAction(0, lastCol, row, new ScriptActionExpectation(0, row));
        }
        return assertions;
    }

    protected List<SlimAssertion> assertionsFromScenario(int row) throws TestExecutionException {
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        String scenarioName = this.getScenarioNameFromAlternatingCells(lastCol, row);
        ScenarioTable scenario = this.getTestContext().getScenario(scenarioName);
        String[] args = null;
        ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
        if (scenario != null) {
            args = this.getArgumentsStartingAt(1, lastCol, row, assertions);
        } else if (lastCol == 0) {
            String cellContents = this.table.getCellContents(0, row);
            scenario = this.getTestContext().getScenarioByPattern(cellContents);
            if (scenario != null) {
                args = scenario.matchParameters(cellContents);
            }
        }
        if (scenario != null) {
            scenario.setCustomComparatorRegistry(this.customComparatorRegistry);
            assertions.addAll(scenario.call(args, this, row));
        }
        return assertions;
    }

    protected String getScenarioNameFromAlternatingCells(int endingCol, int row) throws SyntaxError {
        return RowHelper.getScenarioNameFromAlternatingCells(this.table, endingCol, row);
    }

    protected List<SlimAssertion> note(int row) {
        return Collections.emptyList();
    }

    protected List<SlimAssertion> show(int row) throws SyntaxError {
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        return this.invokeAction(1, lastCol, row, new ShowActionExpectation(0, row));
    }

    protected List<SlimAssertion> ensure(int row) throws SyntaxError {
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        return this.invokeAction(1, lastCol, row, new EnsureActionExpectation(0, row));
    }

    protected List<SlimAssertion> reject(int row) throws SyntaxError {
        int lastCol = this.table.getColumnCountInRow(row) - 1;
        return this.invokeAction(1, lastCol, row, new RejectActionExpectation(0, row));
    }

    protected List<SlimAssertion> checkAction(int row) throws SyntaxError {
        int lastColInAction = this.table.getColumnCountInRow(row) - 1;
        this.table.getCellContents(lastColInAction, row);
        return this.invokeAction(1, lastColInAction - 1, row, new SlimTable.ReturnedValueExpectation(this, lastColInAction, row));
    }

    protected List<SlimAssertion> checkNotAction(int row) throws SyntaxError {
        int lastColInAction = this.table.getColumnCountInRow(row) - 1;
        this.table.getCellContents(lastColInAction, row);
        return this.invokeAction(1, lastColInAction - 1, row, new SlimTable.RejectedValueExpectation(this, lastColInAction, row));
    }

    protected List<SlimAssertion> invokeAction(int startingCol, int endingCol, int row, SlimExpectation expectation) throws SyntaxError {
        String actionName = this.getActionNameStartingAt(startingCol, endingCol, row);
        ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
        String[] args = this.getArgumentsStartingAt(startingCol + 1, endingCol, row, assertions);
        assertions.add(this.makeAssertion(this.callFunction(this.getTableType() + "Actor", actionName, args), expectation));
        return assertions;
    }

    protected String getActionNameStartingAt(int startingCol, int endingCol, int row) throws SyntaxError {
        return RowHelper.getActionNameStartingAt(this.table, startingCol, endingCol, row);
    }

    protected String[] getArgumentsStartingAt(int startingCol, int endingCol, int row, List<SlimAssertion> assertions) {
        ArgumentExtractor extractor = new ArgumentExtractor(startingCol, endingCol, row);
        while (extractor.hasMoreToExtract()) {
            assertions.add(this.makeAssertion(Instruction.NOOP_INSTRUCTION, new ArgumentExpectation(extractor.argumentColumn, row)));
            extractor.extractNextArgument();
        }
        return extractor.getArguments();
    }

    protected boolean invokesSequentialArgumentProcessing(String cellContents) {
        return RowHelper.invokesSequentialArgumentProcessing(cellContents);
    }

    protected List<SlimAssertion> startActor() {
        if (!StringUtils.isBlank(this.getFixtureName())) {
            return this.startActor(0, this.getFixtureName(), 0);
        }
        if (this.table.getColumnCountInRow(0) > 1) {
            return this.startActor(0);
        }
        return null;
    }

    protected List<SlimAssertion> startActor(int row) {
        int classNameColumn = 1;
        String cellContents = this.table.getCellContents(classNameColumn, row);
        return this.startActor(row, cellContents, classNameColumn);
    }

    protected List<SlimAssertion> startActor(int row, String cellContents, int classNameColumn) {
        ArrayList<SlimAssertion> assertions = new ArrayList<SlimAssertion>();
        String className = Disgracer.disgraceClassName(cellContents);
        String actorName = this.getTableType() + "Actor";
        this.getTestContext().setCurrentScriptActor(actorName);
        assertions.add(this.constructInstance(actorName, className, classNameColumn, row));
        this.getArgumentsStartingAt(classNameColumn + 1, this.table.getColumnCountInRow(row) - 1, row, assertions);
        return assertions;
    }

    private class ArgumentExpectation
    extends SlimTable.RowExpectation {
        private ArgumentExpectation(int col, int row) {
            super(ScriptTable.this, col, row);
        }

        @Override
        public TestResult evaluateExpectation(Object returnValue) {
            ScriptTable.this.table.substitute(this.getCol(), this.getRow(), ScriptTable.this.replaceSymbolsWithFullExpansion(this.getExpected()));
            return null;
        }

        @Override
        protected SlimTestResult createEvaluationMessage(String actual, String expected) {
            return null;
        }
    }

    private class ShowActionExpectation
    extends SlimTable.RowExpectation {
        public ShowActionExpectation(int col, int row) {
            super(ScriptTable.this, col, row);
        }

        @Override
        protected SlimTestResult createEvaluationMessage(String actual, String expected) {
            try {
                ScriptTable.this.table.addColumnToRow(this.getRow(), actual);
            }
            catch (Exception e) {
                return SlimTestResult.fail(actual, e.getMessage());
            }
            return SlimTestResult.plain();
        }
    }

    private class RejectActionExpectation
    extends SlimTable.RowExpectation {
        public RejectActionExpectation(int col, int row) {
            super(ScriptTable.this, col, row);
        }

        @Override
        protected SlimTestResult createEvaluationMessage(String actual, String expected) {
            if (actual == null) {
                return SlimTestResult.pass();
            }
            return actual.equals("false") ? SlimTestResult.pass() : SlimTestResult.fail();
        }
    }

    private class EnsureActionExpectation
    extends SlimTable.RowExpectation {
        public EnsureActionExpectation(int col, int row) {
            super(ScriptTable.this, col, row);
        }

        @Override
        protected SlimTestResult createEvaluationMessage(String actual, String expected) {
            return actual != null && actual.equals("true") ? SlimTestResult.pass() : SlimTestResult.fail();
        }
    }

    private class ScriptActionExpectation
    extends SlimTable.RowExpectation {
        private ScriptActionExpectation(int col, int row) {
            super(ScriptTable.this, col, row);
        }

        @Override
        protected SlimTestResult createEvaluationMessage(String actual, String expected) {
            if (actual == null) {
                return SlimTestResult.fail("null", expected);
            }
            if (actual.equals("/__VOID__/") || actual.equals("null")) {
                return SlimTestResult.plain();
            }
            if (actual.equals("false")) {
                return SlimTestResult.fail();
            }
            if (actual.equals("true")) {
                return SlimTestResult.pass();
            }
            return SlimTestResult.plain();
        }
    }

    class ArgumentExtractor {
        private int argumentColumn;
        private int endingCol;
        private int row;
        private List<String> arguments = new ArrayList<String>();
        private int increment = 2;
        private boolean sequentialArguments = false;

        ArgumentExtractor(int startingCol, int endingCol, int row) {
            this.argumentColumn = startingCol;
            this.endingCol = endingCol;
            this.row = row;
        }

        public boolean hasMoreToExtract() {
            return this.argumentColumn <= this.endingCol;
        }

        public void extractNextArgument() {
            this.arguments.add(ScriptTable.this.table.getCellContents(this.argumentColumn, this.row));
            String argumentKeyword = ScriptTable.this.table.getCellContents(this.argumentColumn - 1, this.row);
            boolean argumentIsSequential = ScriptTable.this.invokesSequentialArgumentProcessing(argumentKeyword);
            this.sequentialArguments = this.sequentialArguments || argumentIsSequential;
            this.increment = this.sequentialArguments ? 1 : 2;
            this.argumentColumn += this.increment;
        }

        public String[] getArguments() {
            return this.arguments.toArray(new String[this.arguments.size()]);
        }
    }

    public static class RowHelper {
        private static final String SEQUENTIAL_ARGUMENT_PROCESSING_SUFFIX = ";";

        public static String getScenarioNameFromAlternatingCells(Table table, int endingCol, int row) throws SyntaxError {
            String actionName = RowHelper.getActionNameStartingAt(table, 0, endingCol, row);
            String simpleName = actionName.replace(SEQUENTIAL_ARGUMENT_PROCESSING_SUFFIX, "");
            return Disgracer.disgraceClassName(simpleName);
        }

        public static String getActionNameStartingAt(Table table, int startingCol, int endingCol, int row) throws SyntaxError {
            StringBuilder actionName = new StringBuilder();
            try {
                actionName.append(table.getCellContents(startingCol, row));
            }
            catch (IndexOutOfBoundsException e) {
                throw new SyntaxError("Too few columns in row " + (row + 1) + ". Expected a function in column " + (startingCol + 1) + ".");
            }
            for (int actionNameCol = startingCol + 2; actionNameCol <= endingCol && !RowHelper.invokesSequentialArgumentProcessing(actionName.toString()); actionNameCol += 2) {
                actionName.append(" ").append(table.getCellContents(actionNameCol, row));
            }
            return actionName.toString().trim();
        }

        public static boolean invokesSequentialArgumentProcessing(String cellContents) {
            return cellContents.endsWith(SEQUENTIAL_ARGUMENT_PROCESSING_SUFFIX);
        }
    }
}

