/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MethodExtractorRule {
    private final String scopePattern;
    private final String methodNamePattern;
    private final String parameterListString;
    private final String[] parameterList;
    private final Pattern scope;

    public MethodExtractorRule(String scopePattern, String methodNamePattern, String parameterList) {
        this.scopePattern = scopePattern;
        this.methodNamePattern = methodNamePattern;
        this.parameterListString = parameterList;
        this.parameterList = this.getParameterList().split(",");
        this.scope = Pattern.compile(this.scopePattern);
    }

    public String getScopePattern() {
        return this.scopePattern;
    }

    public String getMethodNamePattern() {
        return this.methodNamePattern;
    }

    public String getParameterList() {
        return this.parameterListString;
    }

    public Matcher matcher(String methodName) {
        return this.scope.matcher(methodName);
    }

    public List<String> getParameterList(Matcher m) {
        ArrayList<String> parameterObjects = new ArrayList<String>();
        for (String parameter : this.parameterList) {
            if (parameter.isEmpty()) continue;
            if (parameter.startsWith("$")) {
                String groupName = parameter.substring(1);
                try {
                    int groupID = Integer.parseInt(groupName);
                    parameterObjects.add(m.group(groupID));
                }
                catch (NumberFormatException e) {
                    parameterObjects.add(m.group(groupName));
                }
                continue;
            }
            parameterObjects.add(parameter);
        }
        return parameterObjects;
    }

    public String getMethodName(Matcher m) {
        return m.replaceAll(this.getMethodNamePattern());
    }

    public String toString() {
        return "Scope:" + this.scopePattern + ";TargetName:" + this.methodNamePattern + ";Parameters:" + this.parameterListString;
    }

    public StringBuilder toJson() {
        StringBuilder sb = new StringBuilder("{\n\"Scope\":\"");
        sb.append(this.getScopePattern().replaceAll("\\\\", "\\\\\\\\"));
        sb.append("\",\n\"TargetName\":\"");
        sb.append(this.getMethodNamePattern().replaceAll("\\\\", "\\\\\\\\"));
        sb.append("\",\n\"Parameters\":\"");
        sb.append(this.getParameterList().replaceAll("\\\\", "\\\\\\\\"));
        sb.append("\"\n}\n");
        return sb;
    }
}

