/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.results;

import fitnesse.testsystems.ExceptionResult;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SlimExceptionResult
implements ExceptionResult {
    public static final Pattern EXCEPTION_MESSAGE_PATTERN = Pattern.compile("message:<<(.*)>>", 32);
    public static final String DEFAULT_SLIM_EXCEPTION_COMPARATOR = "EXCEPTION:";
    private final String resultKey;
    private final String exceptionValue;
    private TestResult catchException;

    public SlimExceptionResult(String resultKey, String exceptionValue) {
        this.resultKey = resultKey;
        this.exceptionValue = exceptionValue;
        this.catchException = null;
    }

    @Override
    public ExecutionResult getExecutionResult() {
        return this.isStopTestException() ? ExecutionResult.FAIL : ExecutionResult.ERROR;
    }

    public boolean hasMessage() {
        return this.getMessage() != null;
    }

    @Override
    public String getMessage() {
        String exceptionMessage = this.getExceptionMessage();
        if (exceptionMessage != null) {
            return this.translateExceptionMessage(exceptionMessage);
        }
        return null;
    }

    private String getExceptionMessage() {
        Matcher exceptionMessageMatcher = EXCEPTION_MESSAGE_PATTERN.matcher(this.exceptionValue);
        if (exceptionMessageMatcher.find()) {
            return exceptionMessageMatcher.group(1);
        }
        return null;
    }

    public String getResultKey() {
        return this.resultKey;
    }

    public String getException() {
        return this.exceptionValue;
    }

    public boolean isCatchException() {
        return this.catchException != null;
    }

    public TestResult catchTestResult() {
        return this.catchException;
    }

    public void setCatchException(TestResult testResult) {
        this.catchException = testResult;
    }

    public boolean isStopTestException() {
        return this.exceptionValue.contains("__EXCEPTION__:ABORT_SLIM_TEST:");
    }

    public boolean isStopSuiteException() {
        return this.exceptionValue.contains("__EXCEPTION__:ABORT_SLIM_SUITE:");
    }

    public boolean isNoMethodInClassException() {
        return this.isExceptionOfType("NO_METHOD_IN_CLASS");
    }

    public boolean isNoInstanceException() {
        return this.isExceptionOfType("NO_INSTANCE");
    }

    private boolean isExceptionOfType(String type) {
        String exceptionMessage = this.getExceptionMessage();
        return exceptionMessage != null && exceptionMessage.contains(type);
    }

    private String translateExceptionMessage(String exceptionMessage) {
        String[] tokens = exceptionMessage.split(" ");
        switch (tokens[0]) {
            case "COULD_NOT_INVOKE_CONSTRUCTOR": {
                return "Could not invoke constructor for " + tokens[1];
            }
            case "NO_METHOD_IN_CLASS": {
                return String.format("Method %s not found in %s", tokens[1], tokens[2]);
            }
            case "NO_CONSTRUCTOR": {
                return String.format("Could not find constructor for %s", tokens[1]);
            }
            case "NO_CONVERTER_FOR_ARGUMENT_NUMBER": {
                return String.format("No converter for %s", tokens[1]);
            }
            case "NO_INSTANCE": {
                return String.format("The instance %s does not exist", tokens[1]);
            }
            case "NO_CLASS": {
                return String.format("Could not find class %s", tokens[1]);
            }
            case "MALFORMED_INSTRUCTION": {
                return String.format("The instruction %s is malformed", exceptionMessage.substring(exceptionMessage.indexOf(" ") + 1));
            }
            case "TIMED_OUT": {
                return String.format("The instruction timed out after %s seconds", tokens[1]);
            }
        }
        return exceptionMessage;
    }
}

