/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.ScriptTable;
import fitnesse.util.TimeMeasurement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlimTestContextImpl
implements SlimTestContext {
    private final Map<String, String> symbols = new HashMap<String, String>();
    private final Map<String, ScenarioTable> scenarios = new HashMap<String, ScenarioTable>(512);
    private final TestSummary testSummary = new TestSummary();
    private final TestPage pageToTest;
    private final TimeMeasurement timeMeasurement;
    private List<ScenarioTable> scenariosWithInputs = null;
    private boolean isSorted = true;
    private String currentScriptActor;
    private Class<? extends ScriptTable> currentScriptClass = ScriptTable.class;

    public SlimTestContextImpl(TestPage pageToTest) {
        this.pageToTest = pageToTest;
        this.timeMeasurement = new TimeMeasurement().start();
    }

    @Override
    public String getSymbol(String symbolName) {
        return this.symbols.get(symbolName);
    }

    @Override
    public Map<String, String> getSymbols() {
        return this.symbols;
    }

    @Override
    public void setSymbol(String symbolName, String value) {
        this.symbols.put(symbolName, value);
    }

    @Override
    public void addScenario(String scenarioName, ScenarioTable scenarioTable) {
        ScenarioTable oldValue = this.scenarios.put(scenarioName, scenarioTable);
        if (this.scenariosWithInputs != null) {
            this.maintainScenariosWithInputs(oldValue, scenarioTable);
        }
    }

    @Override
    public ScenarioTable getScenario(String scenarioName) {
        return this.scenarios.get(scenarioName);
    }

    @Override
    public ScenarioTable getScenarioByPattern(String invokingString) {
        ScenarioTable result = null;
        for (ScenarioTable s : this.getScenariosWithMostArgumentsFirst()) {
            if (!s.canMatchParameters(invokingString)) continue;
            result = s;
            break;
        }
        return result;
    }

    private List<ScenarioTable> getScenariosWithMostArgumentsFirst() {
        if (this.scenariosWithInputs == null) {
            this.initializeScenariosWithInputs();
        }
        if (!this.isSorted) {
            Collections.sort(this.scenariosWithInputs, new ScenarioTableLengthComparator());
            this.isSorted = true;
        }
        return this.scenariosWithInputs;
    }

    private void initializeScenariosWithInputs() {
        int initialCapacity = this.scenarios.size();
        this.scenariosWithInputs = new ArrayList<ScenarioTable>(initialCapacity);
        this.isSorted = true;
        for (ScenarioTable table : this.scenarios.values()) {
            this.addToScenariosWithInputsIfNeeded(table);
        }
    }

    private void maintainScenariosWithInputs(ScenarioTable oldTable, ScenarioTable newTable) {
        if (oldTable != null && !oldTable.getInputs().isEmpty()) {
            this.scenariosWithInputs.remove(oldTable);
        }
        this.addToScenariosWithInputsIfNeeded(newTable);
    }

    private void addToScenariosWithInputsIfNeeded(ScenarioTable newTable) {
        if (!newTable.getInputs().isEmpty()) {
            this.scenariosWithInputs.add(newTable);
            this.isSorted = false;
        }
    }

    @Override
    public Collection<ScenarioTable> getScenarios() {
        return this.scenarios.values();
    }

    @Override
    public void incrementPassedTestsCount() {
        this.increment(ExecutionResult.PASS);
    }

    @Override
    public void incrementFailedTestsCount() {
        this.increment(ExecutionResult.FAIL);
    }

    @Override
    public void incrementErroredTestsCount() {
        this.increment(ExecutionResult.ERROR);
    }

    @Override
    public void incrementIgnoredTestsCount() {
        this.increment(ExecutionResult.IGNORE);
    }

    @Override
    public void increment(ExecutionResult result) {
        this.testSummary.add(result);
    }

    @Override
    public void increment(TestSummary testSummary) {
        this.testSummary.add(testSummary);
    }

    public TestSummary getTestSummary() {
        this.testSummary.setRunTimeInMillis(this.timeMeasurement.elapsed());
        return this.testSummary;
    }

    @Override
    public TestPage getPageToTest() {
        return this.pageToTest;
    }

    @Override
    public void setCurrentScriptClass(Class<? extends ScriptTable> currentScriptClass) {
        this.currentScriptClass = currentScriptClass;
    }

    @Override
    public Class<? extends ScriptTable> getCurrentScriptClass() {
        return this.currentScriptClass;
    }

    @Override
    public void setCurrentScriptActor(String currentScriptActor) {
        this.currentScriptActor = currentScriptActor;
    }

    @Override
    public String getCurrentScriptActor() {
        return this.currentScriptActor;
    }

    private static class ScenarioTableLengthComparator
    implements Comparator<ScenarioTable> {
        private ScenarioTableLengthComparator() {
        }

        @Override
        public int compare(ScenarioTable st1, ScenarioTable st2) {
            int size1 = st1.getInputs().size();
            int size2 = st2.getInputs().size();
            return size2 - size1;
        }
    }
}

