/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.SlimError;
import fitnesse.testsystems.slim.HtmlTable;
import fitnesse.testsystems.slim.TableScanner;
import fitnesse.util.HtmlParserTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class HtmlTableScanner
implements TableScanner<HtmlTable> {
    private List<HtmlTable> tables = new ArrayList<HtmlTable>(16);
    private List<Node> nodes = new ArrayList<Node>(512);

    public HtmlTableScanner(String page) {
        NodeList htmlTree;
        if (page == null || page.equals("")) {
            page = "<i>This page intentionally left blank.</i>";
        }
        try {
            Parser parser = new Parser(new Lexer(new Page(page)));
            htmlTree = parser.parse(null);
        }
        catch (ParserException e) {
            throw new SlimError(e);
        }
        this.scanForTables(htmlTree);
    }

    public HtmlTableScanner(NodeList ... nodeLists) {
        for (NodeList nodeList : nodeLists) {
            this.scanForTables(nodeList);
        }
    }

    private void scanForTables(NodeList nodes) {
        this.scanForTables(nodes, false);
    }

    private void scanForTables(NodeList nodes, boolean markAsTeardown) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node endNode;
            Node node = nodes.elementAt(i);
            if (node instanceof TableTag) {
                TableTag tableTag = HtmlParserTools.deepClone((TableTag)node);
                HtmlTable htmlTable = new HtmlTable(tableTag);
                htmlTable.setTearDown(markAsTeardown);
                this.tables.add(htmlTable);
                this.nodes.add(tableTag);
                continue;
            }
            this.nodes.add(HtmlParserTools.flatClone(node));
            NodeList children = node.getChildren();
            if (children != null) {
                this.scanForTables(children, markAsTeardown || HtmlParserTools.nodeHasClass(node, "teardown"));
            }
            if ((endNode = HtmlParserTools.endTag(node)) == null) continue;
            this.nodes.add(endNode);
        }
    }

    @Override
    public int getTableCount() {
        return this.tables.size();
    }

    @Override
    public HtmlTable getTable(int i) {
        return this.tables.get(i);
    }

    @Override
    public Iterator<HtmlTable> iterator() {
        return this.tables.iterator();
    }

    public String toHtml(HtmlTable startTable, HtmlTable endBeforeTable) {
        int index = 0;
        if (startTable != null) {
            index = this.nodes.indexOf(startTable.getTableNode());
        }
        TableTag endTag = null;
        if (endBeforeTable != null) {
            endTag = endBeforeTable.getTableNode();
        }
        StringBuilder html = new StringBuilder(512);
        for (int i = index; i < this.nodes.size() && this.nodes.get(i) != endTag; ++i) {
            Node node = this.nodes.get(i);
            html.append(node.toHtml());
        }
        return html.toString();
    }

    public String toHtml() {
        return this.toHtml(null, null);
    }
}

