/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.fit;

import fit.Counts;
import fit.FitProtocol;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.fit.FitClientListener;
import fitnesse.testsystems.fit.SocketAccepter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import util.StreamReader;

public class FitClient
implements SocketAccepter {
    private static final Logger LOG = Logger.getLogger(FitClient.class.getName());
    private List<FitClientListener> listeners = new LinkedList<FitClientListener>();
    private Socket fitSocket;
    private OutputStream fitInput;
    private StreamReader fitOutput;
    private volatile int sent = 0;
    private volatile int received = 0;
    private volatile boolean isDoneSending = false;
    private volatile boolean killed = false;
    private Thread fitListeningThread;

    public void addFitClientListener(FitClientListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void acceptSocket(Socket socket) throws IOException, InterruptedException {
        this.checkForPulse();
        this.fitSocket = socket;
        this.fitInput = this.fitSocket.getOutputStream();
        FitProtocol.writeData("", this.fitInput);
        this.fitOutput = new StreamReader(this.fitSocket.getInputStream());
        this.fitListeningThread = new Thread((Runnable)new FitListeningRunnable(), "FitClient fitOutput");
        this.fitListeningThread.start();
    }

    public void send(String data) throws IOException, InterruptedException {
        this.checkForPulse();
        FitProtocol.writeData(data, this.fitInput);
        ++this.sent;
    }

    public void done() throws IOException, InterruptedException {
        this.checkForPulse();
        FitProtocol.writeSize(0, this.fitInput);
        this.isDoneSending = true;
    }

    public void join() {
        if (this.fitListeningThread != null) {
            try {
                this.fitListeningThread.join();
            }
            catch (InterruptedException e) {
                LOG.log(Level.FINE, "Wait for join of listening thread interrupted");
                Thread.currentThread().interrupt();
            }
        }
    }

    public void kill() {
        this.killed = true;
        if (this.fitListeningThread != null) {
            this.fitListeningThread.interrupt();
        }
    }

    public synchronized boolean isSuccessfullyStarted() {
        return this.fitSocket != null;
    }

    protected void checkForPulse() throws InterruptedException {
        if (this.killed) {
            throw new InterruptedException("FitClient was killed");
        }
    }

    private boolean finishedReading() throws InterruptedException {
        while (this.stateIndeterminate()) {
            this.shortSleep();
        }
        return this.isDoneSending && this.received == this.sent;
    }

    private boolean stateIndeterminate() {
        return this.received == this.sent && !this.isDoneSending;
    }

    private void shortSleep() throws InterruptedException {
        Thread.sleep(10L);
    }

    public void exceptionOccurred(Throwable cause) {
        for (FitClientListener listener : this.listeners) {
            listener.exceptionOccurred(cause);
        }
    }

    private class FitListeningRunnable
    implements Runnable {
        private FitListeningRunnable() {
        }

        @Override
        public void run() {
            this.listenToFit();
        }

        private void listenToFit() {
            try {
                this.attemptToListenToFit();
            }
            catch (Exception e) {
                FitClient.this.exceptionOccurred(e);
            }
        }

        private void attemptToListenToFit() throws IOException, InterruptedException {
            while (!FitClient.this.finishedReading()) {
                int size = FitProtocol.readSize(FitClient.this.fitOutput);
                if (size != 0) {
                    String readValue = FitClient.this.fitOutput.read(size);
                    if (FitClient.this.fitOutput.byteCount() < size) {
                        throw new IOException("I was expecting " + size + " bytes but I only got " + FitClient.this.fitOutput.byteCount());
                    }
                    this.testOutputChunk(readValue);
                    continue;
                }
                Counts counts = FitProtocol.readCounts(FitClient.this.fitOutput);
                this.testComplete(new TestSummary(counts.right, counts.wrong, counts.ignores, counts.exceptions));
                FitClient.this.received++;
            }
        }

        private void testComplete(TestSummary summary) throws IOException {
            for (FitClientListener listener : FitClient.this.listeners) {
                listener.testComplete(summary);
            }
        }

        private void testOutputChunk(String value) throws IOException {
            for (FitClientListener listener : FitClient.this.listeners) {
                listener.testOutputChunk(value);
            }
        }
    }
}

