/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.fit;

import fitnesse.socketservice.PlainServerSocketFactory;
import fitnesse.socketservice.SocketService;
import fitnesse.testsystems.CommandRunner;
import fitnesse.testsystems.ExecutionLogListener;
import fitnesse.testsystems.MockCommandRunner;
import fitnesse.testsystems.fit.FitClient;
import fitnesse.testsystems.fit.SocketCatcher;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;

public class CommandRunningFitClient
extends FitClient {
    private static final Logger LOG = Logger.getLogger(CommandRunningFitClient.class.getName());
    public static int TIMEOUT = 60000;
    private final int ticketNumber = this.generateTicketNumber();
    private final CommandRunningStrategy commandRunningStrategy;
    private boolean connectionEstablished = false;
    private SocketService server;

    public CommandRunningFitClient(CommandRunningStrategy commandRunningStrategy) {
        this.commandRunningStrategy = commandRunningStrategy;
    }

    private int generateTicketNumber() {
        return 3863;
    }

    public void start() throws IOException {
        ServerSocket serverSocket = new PlainServerSocketFactory().createServerSocket(0);
        this.server = new SocketService(new SocketCatcher(this, this.ticketNumber), true, serverSocket);
        int port = serverSocket.getLocalPort();
        try {
            this.commandRunningStrategy.start(this, port, this.ticketNumber);
            this.waitForConnection();
        }
        catch (Exception e) {
            this.exceptionOccurred(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptSocket(Socket s) throws IOException, InterruptedException {
        super.acceptSocket(s);
        this.connectionEstablished = true;
        CommandRunningFitClient commandRunningFitClient = this;
        synchronized (commandRunningFitClient) {
            this.notify();
        }
    }

    private void waitForConnection() throws InterruptedException {
        while (!this.isSuccessfullyStarted()) {
            Thread.sleep(100L);
            this.checkForPulse();
        }
    }

    public boolean isConnectionEstablished() {
        return this.connectionEstablished;
    }

    @Override
    public void join() {
        try {
            this.commandRunningStrategy.join();
            super.join();
            this.commandRunningStrategy.kill();
        }
        finally {
            this.closeServer();
        }
    }

    private void closeServer() {
        try {
            this.server.close();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Unable to close FitClient socket server", e);
        }
    }

    @Override
    public void kill() {
        super.kill();
        this.commandRunningStrategy.kill();
    }

    private static String getLocalhostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public static class InProcessCommandRunner
    implements CommandRunningStrategy {
        private final Method testRunnerMethod;
        private final ExecutionLogListener executionLogListener;
        private ClassLoader classLoader;
        private Thread fastFitServer;
        private MockCommandRunner commandRunner;

        public InProcessCommandRunner(Method testRunnerMethod, ExecutionLogListener executionLogListener, ClassLoader classLoader) {
            this.testRunnerMethod = testRunnerMethod;
            this.executionLogListener = executionLogListener;
            this.classLoader = classLoader;
        }

        @Override
        public void start(CommandRunningFitClient fitClient, int port, int ticketNumber) throws IOException {
            String[] arguments = new String[]{"-x", CommandRunningFitClient.getLocalhostName(), Integer.toString(port), Integer.toString(ticketNumber)};
            this.fastFitServer = this.createTestRunnerThread(this.testRunnerMethod, arguments);
            this.fastFitServer.start();
            this.commandRunner = new MockCommandRunner(this.executionLogListener);
            this.commandRunner.asynchronousStart();
        }

        @Override
        public void join() {
            try {
                this.fastFitServer.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void kill() {
            this.commandRunner.kill();
        }

        protected Thread createTestRunnerThread(final Method testRunnerMethod, final String[] args) {
            Runnable fastFitServerRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        testRunnerMethod.invoke(null, new Object[]{args});
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        LOG.log(Level.WARNING, "Could not start in-process test runner", e);
                    }
                }
            };
            Thread fitServerThread = new Thread(fastFitServerRunnable);
            fitServerThread.setContextClassLoader(this.classLoader);
            fitServerThread.setDaemon(true);
            return fitServerThread;
        }
    }

    public static class OutOfProcessCommandRunner
    implements CommandRunningStrategy {
        private final String[] command;
        private final Map<String, String> environmentVariables;
        private final ExecutionLogListener executionLogListener;
        private Thread timeoutThread;
        private Thread earlyTerminationThread;
        private CommandRunner commandRunner;

        public OutOfProcessCommandRunner(String[] command, Map<String, String> environmentVariables, ExecutionLogListener executionLogListener) {
            this.command = command;
            this.environmentVariables = environmentVariables;
            this.executionLogListener = executionLogListener;
        }

        private void makeCommandRunner(int port, int ticketNumber) throws UnknownHostException {
            String[] fitArguments = new String[]{CommandRunningFitClient.getLocalhostName(), Integer.toString(port), Integer.toString(ticketNumber)};
            String[] commandLine = ArrayUtils.addAll(this.command, fitArguments);
            this.commandRunner = new CommandRunner(commandLine, this.environmentVariables, this.executionLogListener);
        }

        @Override
        public void start(CommandRunningFitClient fitClient, int port, int ticketNumber) throws IOException {
            this.makeCommandRunner(port, ticketNumber);
            this.commandRunner.asynchronousStart();
            this.timeoutThread = new Thread((Runnable)new TimeoutRunnable(fitClient), "FitClient timeout");
            this.timeoutThread.start();
            this.earlyTerminationThread = new Thread((Runnable)new EarlyTerminationRunnable(fitClient, this.commandRunner), "FitClient early termination");
            this.earlyTerminationThread.start();
        }

        @Override
        public void join() {
            this.commandRunner.join();
            this.killVigilantThreads();
        }

        @Override
        public void kill() {
            this.commandRunner.kill();
            this.killVigilantThreads();
        }

        private void killVigilantThreads() {
            if (this.timeoutThread != null) {
                this.timeoutThread.interrupt();
            }
            if (this.earlyTerminationThread != null) {
                this.earlyTerminationThread.interrupt();
            }
        }

        private static class EarlyTerminationRunnable
        implements Runnable {
            private final CommandRunningFitClient fitClient;
            private final CommandRunner commandRunner;

            EarlyTerminationRunnable(CommandRunningFitClient fitClient, CommandRunner commandRunner) {
                this.fitClient = fitClient;
                this.commandRunner = commandRunner;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    this.commandRunner.waitForCommandToFinish();
                    CommandRunningFitClient commandRunningFitClient = this.fitClient;
                    synchronized (commandRunningFitClient) {
                        if (!this.fitClient.isConnectionEstablished()) {
                            this.fitClient.notify();
                            Exception e = new Exception("FitClient external process terminated before a connection could be established");
                            this.commandRunner.exceptionOccurred(e);
                            this.fitClient.exceptionOccurred(e);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private static class TimeoutRunnable
        implements Runnable {
            private final FitClient fitClient;

            public TimeoutRunnable(FitClient fitClient) {
                this.fitClient = fitClient;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(TIMEOUT);
                    FitClient fitClient = this.fitClient;
                    synchronized (fitClient) {
                        if (!this.fitClient.isSuccessfullyStarted()) {
                            this.fitClient.notify();
                            this.fitClient.exceptionOccurred(new Exception("FitClient communication socket was not received on time"));
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static interface CommandRunningStrategy {
        public void start(CommandRunningFitClient var1, int var2, int var3) throws IOException;

        public void join();

        public void kill();
    }
}

