/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.testsystems.TestSummary;

public enum ExecutionResult {
    ERROR,
    FAIL,
    IGNORE,
    PASS;


    public String toString() {
        return this.name().toLowerCase();
    }

    public static ExecutionResult getExecutionResult(String relativeName, TestSummary testSummary) {
        return ExecutionResult.getExecutionResult(relativeName, testSummary, false);
    }

    public static ExecutionResult getExecutionResult(String relativeName, TestSummary testSummary, boolean wasInterrupted) {
        if (testSummary.getWrong() > 0 || wasInterrupted) {
            return FAIL;
        }
        if (testSummary.getExceptions() > 0) {
            return ERROR;
        }
        if ((ExecutionResult.isSuiteMetaPage(relativeName) && testSummary.getIgnores() > 0 || !ExecutionResult.isSuiteMetaPage(relativeName) && testSummary.getIgnores() >= 0) && testSummary.getRight() == 0) {
            return IGNORE;
        }
        return PASS;
    }

    public static ExecutionResult getExecutionResult(TestSummary testSummary) {
        if (testSummary.getWrong() > 0) {
            return FAIL;
        }
        if (testSummary.getExceptions() > 0) {
            return ERROR;
        }
        if (testSummary.getRight() > 0) {
            return PASS;
        }
        return IGNORE;
    }

    public static boolean isSuiteMetaPage(String relativeName) {
        return relativeName != null && (relativeName.equals("SuiteSetUp") || relativeName.endsWith(".SuiteSetUp") || relativeName.equals("SuiteTearDown") || relativeName.endsWith(".SuiteTearDown"));
    }
}

