/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.testsystems.ExecutionLogListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import util.FileUtil;

public class CommandRunner {
    private static final Logger LOG = Logger.getLogger(CommandRunner.class.getName());
    private Process process;
    private String[] command;
    private Map<String, String> environmentVariables;
    private final int timeout;
    private final ExecutionLogListener executionLogListener;
    private String commandErrorMessage = "";

    public CommandRunner(String[] command, Map<String, String> environmentVariables, ExecutionLogListener executionLogListener, int timeout) {
        if (executionLogListener == null) {
            throw new IllegalArgumentException("executionLogListener may not be null");
        }
        this.command = command;
        this.environmentVariables = environmentVariables;
        this.executionLogListener = executionLogListener;
        this.timeout = timeout;
    }

    public CommandRunner(String[] command, Map<String, String> environmentVariables, ExecutionLogListener executionLogListener) {
        this(command, environmentVariables, executionLogListener, 2);
    }

    public void asynchronousStart() throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(this.command);
        processBuilder.environment().putAll(this.determineEnvironment());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Starting process " + Arrays.asList(this.command));
        }
        this.process = processBuilder.start();
        this.sendCommandStartedEvent();
        this.redirectOutputs(this.process, this.executionLogListener);
    }

    protected void redirectOutputs(Process process, final ExecutionLogListener executionLogListener) throws IOException {
        InputStream stdout = process.getInputStream();
        InputStream stderr = process.getErrorStream();
        new Thread((Runnable)new OutputReadingRunnable(stdout, new OutputWriter(){

            @Override
            public void write(String output) {
                executionLogListener.stdOut(output);
            }
        }), "CommandRunner stdOut").start();
        new Thread((Runnable)new OutputReadingRunnable(stderr, new OutputWriter(){

            @Override
            public void write(String output) {
                executionLogListener.stdErr(output);
                CommandRunner.this.setCommandErrorMessage(output);
            }
        }), "CommandRunner stdErr").start();
        process.getOutputStream().close();
    }

    protected void sendCommandStartedEvent() {
        this.executionLogListener.commandStarted(new ExecutionLogListener.ExecutionContext(){

            @Override
            public String getCommand() {
                return StringUtils.join(Arrays.asList(CommandRunner.this.command), " ");
            }

            @Override
            public String getTestSystemName() {
                return "command";
            }
        });
    }

    private Map<String, String> determineEnvironment() {
        if (this.environmentVariables == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> systemVariables = new HashMap<String, String>(System.getenv());
        systemVariables.putAll(this.environmentVariables);
        return systemVariables;
    }

    public void join() {
        if (this.process != null) {
            this.waitForDeathOf(this.process);
            if (this.isDead(this.process)) {
                int exitCode = this.process.exitValue();
                this.executionLogListener.exitCode(exitCode);
            }
        }
    }

    private void waitForDeathOf(Process process) {
        int timeStep = 100;
        int maxDelay = this.timeout * 1000;
        try {
            for (int delayed = 0; delayed < maxDelay; delayed += timeStep) {
                if (this.isDead(process)) {
                    return;
                }
                Thread.sleep(timeStep);
            }
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "Wait for death of process " + process + " interrupted", e);
            Thread.currentThread().interrupt();
        }
        LOG.warning("Could not detect death of command line test runner.");
    }

    private boolean isDead(Process process) {
        try {
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public boolean isDead() {
        if (this.process != null) {
            return this.isDead(this.process);
        }
        return false;
    }

    public void kill() {
        if (this.process != null) {
            this.process.destroy();
            this.join();
        }
    }

    public String[] getCommand() {
        return this.command;
    }

    public String getOutput() {
        return "";
    }

    public String getError() {
        return "";
    }

    public List<Throwable> getExceptions() {
        return Collections.emptyList();
    }

    public void exceptionOccurred(Exception e) {
        this.executionLogListener.exceptionOccurred(e);
    }

    public int waitForCommandToFinish() throws InterruptedException {
        return this.process.waitFor();
    }

    protected void setCommandErrorMessage(String commandErrorMessage) {
        this.commandErrorMessage = commandErrorMessage;
    }

    public String getCommandErrorMessage() {
        return this.commandErrorMessage;
    }

    public InputStream getInputStream() {
        return this.process.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    protected static interface OutputWriter {
        public void write(String var1);
    }

    protected class OutputReadingRunnable
    implements Runnable {
        public OutputWriter writer;
        private BufferedReader reader;

        public OutputReadingRunnable(InputStream input, OutputWriter writer) {
            try {
                this.reader = new BufferedReader(new InputStreamReader(input, FileUtil.CHARENCODING));
            }
            catch (UnsupportedEncodingException e) {
                CommandRunner.this.exceptionOccurred(e);
            }
            this.writer = writer;
        }

        @Override
        public void run() {
            try {
                String s;
                while ((s = this.reader.readLine()) != null) {
                    this.writer.write(s);
                }
            }
            catch (Exception e) {
                CommandRunner.this.exceptionOccurred(e);
            }
        }
    }
}

