/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class ClassPath {
    private static final Logger LOG = Logger.getLogger(ClassPath.class.getName());
    private final List<String> elements;
    private final String separator;

    public ClassPath(List<String> elements, String separator) {
        this.elements = elements;
        this.separator = separator;
    }

    public ClassPath(String defaultPath, String pathSeparator) {
        this(Collections.singletonList(defaultPath), pathSeparator);
    }

    public ClassPath(List<ClassPath> paths) {
        this.elements = new ArrayList<String>();
        this.separator = paths.get(0).getSeparator();
        for (ClassPath path : paths) {
            for (String element : path.getElements()) {
                if (this.elements.contains(element)) continue;
                this.elements.add(element);
            }
        }
    }

    public ClassPath withLocationForClass(String testRunner) {
        String location = this.findLocationForClass(testRunner);
        if (location != null) {
            ArrayList<String> newElements = new ArrayList<String>();
            newElements.add(location);
            newElements.addAll(this.elements);
            return new ClassPath(newElements, this.separator);
        }
        return this;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String toString() {
        if (this.elements.isEmpty()) {
            return "defaultPath";
        }
        return StringUtils.join(this.elements, this.separator);
    }

    private String findLocationForClass(String mainClass) {
        String mainClassFile = mainClass.replaceAll("\\.", "/") + ".class";
        URL url = this.getClass().getClassLoader().getResource(mainClassFile);
        if (url == null) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            URI uri = this.toUri(url);
            if (uri != null) {
                String path = uri.getPath();
                return new File(path.substring(0, path.length() - mainClassFile.length())).getAbsolutePath();
            }
        } else if ("jar".equals(url.getProtocol())) {
            String path = url.getPath();
            return new File(URI.create(path.substring(0, path.indexOf("!/")))).getAbsolutePath();
        }
        return null;
    }

    private URI toUri(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            LOG.log(Level.SEVERE, "Could not convert URL '" + url + "' to URI. Ignoring it for now.", e);
            return null;
        }
    }
}

