/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner.run;

import fitnesse.testrunner.run.PerTestSystemTestRun;
import fitnesse.testrunner.run.TestRun;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class TestRunFactory {
    private static TestRunFactory ourInstance = new TestRunFactory();
    private final List<Function<List<WikiPage>, Optional<TestRun>>> runProviders = new ArrayList<Function<List<WikiPage>, Optional<TestRun>>>();

    public static TestRunFactory getInstance() {
        return ourInstance;
    }

    private TestRunFactory() {
    }

    public void resetProviders() {
        this.runProviders.clear();
    }

    public void addProvider(Function<List<WikiPage>, Optional<TestRun>> provider) {
        this.runProviders.add(0, provider);
    }

    public TestRun createRun(List<WikiPage> pages) {
        for (Function<List<WikiPage>, Optional<TestRun>> provider : this.runProviders) {
            Optional<TestRun> run = provider.apply(pages);
            if (!run.isPresent()) continue;
            return run.get();
        }
        return new PerTestSystemTestRun(pages);
    }
}

