/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner.run;

import fitnesse.testrunner.TestPageWithSuiteSetUpAndTearDown;
import fitnesse.testrunner.WikiPageIdentity;
import fitnesse.testrunner.WikiTestPage;
import fitnesse.testrunner.run.PageListSetUpTearDownInserter;
import fitnesse.testrunner.run.PageListSetUpTearDownProcessor;
import fitnesse.testrunner.run.PageListSetUpTearDownSurrounder;
import fitnesse.testsystems.TestPage;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PagesByTestSystem {
    private final PageListSetUpTearDownProcessor processor;
    private final Map<WikiPageIdentity, List<TestPage>> pagesByTestSystem;

    public PagesByTestSystem(List<WikiPage> pages) {
        this(pages.isEmpty() || !TestPageWithSuiteSetUpAndTearDown.includeAllSetupsAndTearDowns(pages.get(0)) ? new PageListSetUpTearDownSurrounder() : new PageListSetUpTearDownInserter(), pages);
    }

    public PagesByTestSystem(PageListSetUpTearDownProcessor processor, List<WikiPage> pages) {
        this.processor = processor;
        Map<WikiPageIdentity, List<WikiPage>> testsPerSystem = this.mapWithAllPagesButSuiteSetUpAndTearDown(pages);
        this.pagesByTestSystem = this.addSuiteSetUpAndTearDownToAllTestSystems(testsPerSystem);
    }

    private Map<WikiPageIdentity, List<WikiPage>> mapWithAllPagesButSuiteSetUpAndTearDown(List<WikiPage> pages) {
        HashMap<WikiPageIdentity, List<WikiPage>> pagesByTestSystem = new HashMap<WikiPageIdentity, List<WikiPage>>();
        for (WikiPage wikiPage : pages) {
            if (WikiTestPage.isSuiteSetupOrTearDown(wikiPage)) continue;
            WikiPageIdentity identity = new WikiPageIdentity(wikiPage);
            pagesByTestSystem.computeIfAbsent(identity, i -> new LinkedList()).add(wikiPage);
        }
        return pagesByTestSystem;
    }

    private Map<WikiPageIdentity, List<TestPage>> addSuiteSetUpAndTearDownToAllTestSystems(Map<WikiPageIdentity, List<WikiPage>> testsPerSystem) {
        HashMap<WikiPageIdentity, List<TestPage>> orderedPagesByTestSystem = new HashMap<WikiPageIdentity, List<TestPage>>();
        if (!testsPerSystem.isEmpty()) {
            for (Map.Entry<WikiPageIdentity, List<WikiPage>> entry : testsPerSystem.entrySet()) {
                WikiPageIdentity system = entry.getKey();
                List<WikiPage> testPages = entry.getValue();
                List<WikiPage> allPages = this.processor.addSuiteSetUpsAndTearDowns(testPages);
                orderedPagesByTestSystem.put(system, this.asTestPages(allPages));
            }
        }
        return orderedPagesByTestSystem;
    }

    private List<TestPage> asTestPages(List<WikiPage> wikiPages) {
        ArrayList<TestPage> testPages = new ArrayList<TestPage>(wikiPages.size());
        for (WikiPage page : wikiPages) {
            testPages.add(new WikiTestPage(page));
        }
        return testPages;
    }

    public int totalTestsToRun() {
        int tests = 0;
        for (List<TestPage> listOfPagesToRun : this.pagesByTestSystem.values()) {
            tests += listOfPagesToRun.size();
        }
        return tests;
    }

    public Collection<WikiPageIdentity> identities() {
        return this.pagesByTestSystem.keySet();
    }

    public List<TestPage> testPagesForIdentity(WikiPageIdentity identity) {
        return Collections.unmodifiableList(this.pagesByTestSystem.get(identity));
    }
}

