/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.testrunner.CompositeFormatter;
import fitnesse.testrunner.Stoppable;
import fitnesse.testrunner.WikiPageIdentity;
import fitnesse.testrunner.run.RunCoordinator;
import fitnesse.testrunner.run.TestRun;
import fitnesse.testrunner.run.TestRunFactory;
import fitnesse.testsystems.Assertion;
import fitnesse.testsystems.ClassPath;
import fitnesse.testsystems.CompositeExecutionLogListener;
import fitnesse.testsystems.Descriptor;
import fitnesse.testsystems.ExceptionResult;
import fitnesse.testsystems.ExecutionLogListener;
import fitnesse.testsystems.TestExecutionException;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestResult;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemFactory;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.slim.TestingInterruptedException;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import util.FileUtil;

public class MultipleTestsRunner
implements Stoppable {
    private final TestRun run;
    private final CompositeFormatter formatters;
    private final TestSystemFactory testSystemFactory;
    private final CompositeExecutionLogListener executionLogListener;
    private volatile boolean isStopped = false;
    private boolean runInProcess;
    private boolean enableRemoteDebug;
    private final AtomicInteger testsInProgressCount = new AtomicInteger();

    public MultipleTestsRunner(List<WikiPage> pages, TestSystemFactory testSystemFactory) {
        this.testSystemFactory = testSystemFactory;
        this.formatters = new CompositeFormatter();
        this.executionLogListener = new CompositeExecutionLogListener();
        this.run = this.createRun(pages);
    }

    public void setRunInProcess(boolean runInProcess) {
        this.runInProcess = runInProcess;
    }

    public void setEnableRemoteDebug(boolean enableRemoteDebug) {
        this.enableRemoteDebug = enableRemoteDebug;
    }

    public void addTestSystemListener(TestSystemListener listener) {
        this.formatters.addTestSystemListener(listener);
    }

    public void addExecutionLogListener(ExecutionLogListener listener) {
        this.executionLogListener.addExecutionLogListener(listener);
    }

    public void executeTestPages() throws TestExecutionException {
        MultipleTestsCoordinator coordinator = new MultipleTestsCoordinator();
        try {
            this.run.executeTestPages(coordinator);
        }
        catch (Exception e) {
            this.executionLogListener.exceptionOccurred(e);
            throw new TestingInterruptedException(e);
        }
        finally {
            this.allTestingComplete();
        }
    }

    @Override
    public void stop() {
        boolean wasNotStopped = this.isNotStopped();
        this.isStopped = true;
        if (wasNotStopped) {
            this.run.stop();
        }
    }

    private TestRun createRun(List<WikiPage> pages) {
        return TestRunFactory.getInstance().createRun(pages);
    }

    private void allTestingComplete() {
        FileUtil.close(this.formatters);
    }

    private boolean isNotStopped() {
        return !this.isStopped;
    }

    private class InternalTestSystemListener
    implements TestSystemListener {
        private InternalTestSystemListener() {
        }

        @Override
        public void testSystemStarted(TestSystem testSystem) {
            MultipleTestsRunner.this.formatters.testSystemStarted(testSystem);
        }

        @Override
        public void testOutputChunk(String output) {
            MultipleTestsRunner.this.formatters.testOutputChunk(output);
        }

        @Override
        public void testStarted(TestPage testPage) {
            MultipleTestsRunner.this.formatters.testStarted(testPage);
        }

        @Override
        public void testComplete(TestPage testPage, TestSummary testSummary) {
            MultipleTestsRunner.this.formatters.testComplete(testPage, testSummary);
            MultipleTestsRunner.this.testsInProgressCount.getAndDecrement();
        }

        @Override
        public void testSystemStopped(TestSystem testSystem, Throwable cause) {
            MultipleTestsRunner.this.formatters.testSystemStopped(testSystem, cause);
            if (cause != null) {
                MultipleTestsRunner.this.executionLogListener.exceptionOccurred(cause);
                MultipleTestsRunner.this.stop();
            }
        }

        @Override
        public void testAssertionVerified(Assertion assertion, TestResult testResult) {
            MultipleTestsRunner.this.formatters.testAssertionVerified(assertion, testResult);
        }

        @Override
        public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
            MultipleTestsRunner.this.formatters.testExceptionOccurred(assertion, exceptionResult);
        }
    }

    private class MultipleTestsCoordinator
    implements RunCoordinator {
        private MultipleTestsCoordinator() {
        }

        @Override
        public boolean isNotStopped() {
            return MultipleTestsRunner.this.isNotStopped();
        }

        @Override
        public int announceTestStarted() {
            return MultipleTestsRunner.this.testsInProgressCount.getAndIncrement();
        }

        @Override
        public void reportException(Exception e) {
            MultipleTestsRunner.this.executionLogListener.exceptionOccurred(e);
        }

        @Override
        public TestSystem startTestSystem(final WikiPageIdentity identity, final List<TestPage> testPages) {
            Descriptor descriptor = new Descriptor(){
                private ClassPath classPath;

                @Override
                public String getTestSystem() {
                    String testSystemName = this.getVariable("TEST_SYSTEM");
                    if (testSystemName == null) {
                        return "fit";
                    }
                    return testSystemName;
                }

                @Override
                public String getTestSystemType() {
                    return this.getTestSystem().split(":")[0];
                }

                @Override
                public ClassPath getClassPath() {
                    if (this.classPath == null) {
                        ArrayList<ClassPath> paths = new ArrayList<ClassPath>();
                        for (TestPage testPage : testPages) {
                            paths.add(testPage.getClassPath());
                        }
                        this.classPath = new ClassPath(paths);
                    }
                    return this.classPath;
                }

                @Override
                public boolean runInProcess() {
                    return MultipleTestsRunner.this.runInProcess;
                }

                @Override
                public boolean isDebug() {
                    return MultipleTestsRunner.this.enableRemoteDebug;
                }

                @Override
                public String getVariable(String name) {
                    return identity.getVariable(name);
                }

                @Override
                public ExecutionLogListener getExecutionLogListener() {
                    return MultipleTestsRunner.this.executionLogListener;
                }
            };
            InternalTestSystemListener internalTestSystemListener = new InternalTestSystemListener();
            try {
                TestSystem testSystem = MultipleTestsRunner.this.testSystemFactory.create(descriptor);
                testSystem.addTestSystemListener(internalTestSystemListener);
                testSystem.start();
                return testSystem;
            }
            catch (Exception e) {
                MultipleTestsRunner.this.formatters.unableToStartTestSystem(descriptor.getTestSystem(), e);
                return null;
            }
        }

        @Override
        public void waitForNoTestsInProgress() throws TestingInterruptedException {
            while (MultipleTestsRunner.this.testsInProgressCount.get() > 0 && this.isNotStopped()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new TestingInterruptedException("Interrupted while waiting for test results", e);
                }
            }
        }

        @Override
        public void announceTotalTestsToRun(int toRun) {
            MultipleTestsRunner.this.formatters.announceNumberTestsToRun(toRun);
        }
    }
}

