/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.testrunner.TestSystemFactoryRegistry;
import fitnesse.testsystems.Descriptor;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemFactory;
import fitnesse.testsystems.fit.CommandRunningFitClient;
import fitnesse.testsystems.fit.FitClientBuilder;
import fitnesse.testsystems.fit.FitTestSystem;
import fitnesse.testsystems.fit.InProcessFitClientBuilder;
import fitnesse.testsystems.slim.CustomComparatorRegistry;
import fitnesse.testsystems.slim.HtmlSlimTestSystem;
import fitnesse.testsystems.slim.InProcessSlimClientBuilder;
import fitnesse.testsystems.slim.SlimClient;
import fitnesse.testsystems.slim.SlimClientBuilder;
import fitnesse.testsystems.slim.SlimCommandRunningClient;
import fitnesse.testsystems.slim.tables.SlimTableFactory;
import java.util.HashMap;
import java.util.Map;

public class MultipleTestSystemFactory
implements TestSystemFactory,
TestSystemFactoryRegistry {
    private final Map<String, TestSystemFactory> testSystemFactories = new HashMap<String, TestSystemFactory>(4);
    private final Map<String, TestSystemFactory> inProcessTestSystemFactories = new HashMap<String, TestSystemFactory>(4);

    public MultipleTestSystemFactory(SlimTableFactory slimTableFactory, CustomComparatorRegistry customComparatorRegistry, ClassLoader classLoader) {
        this.registerTestSystemFactory("slim", new HtmlSlimTestSystemFactory(slimTableFactory, customComparatorRegistry));
        this.registerTestSystemFactory("fit", new FitTestSystemFactory());
        this.registerInProcessTestSystemFactory("slim", new InProcessHtmlSlimTestSystemFactory(slimTableFactory, customComparatorRegistry, classLoader));
        this.registerInProcessTestSystemFactory("fit", new InProcessFitTestSystemFactory(classLoader));
    }

    @Override
    public void registerTestSystemFactory(String name, TestSystemFactory testSystemFactory) {
        this.testSystemFactories.put(name, testSystemFactory);
    }

    public void registerInProcessTestSystemFactory(String name, TestSystemFactory testSystemFactory) {
        this.inProcessTestSystemFactories.put(name, testSystemFactory);
    }

    @Override
    public TestSystem create(Descriptor descriptor) {
        TestSystemFactory factory = null;
        if (descriptor.runInProcess()) {
            factory = this.inProcessTestSystemFactories.get(descriptor.getTestSystemType().toLowerCase());
        }
        if (factory == null) {
            factory = this.testSystemFactories.get(descriptor.getTestSystemType().toLowerCase());
        }
        if (factory == null) {
            throw new RuntimeException(String.format("Unknown test system: '%s'", descriptor.getTestSystemType()));
        }
        return factory.create(descriptor);
    }

    static class InProcessFitTestSystemFactory
    implements TestSystemFactory {
        private final ClassLoader classLoader;

        public InProcessFitTestSystemFactory(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public FitTestSystem create(Descriptor descriptor) {
            InProcessFitClientBuilder clientBuilder = new InProcessFitClientBuilder(descriptor, this.classLoader);
            CommandRunningFitClient fitClient = clientBuilder.build();
            return new FitTestSystem(clientBuilder.getTestSystemName(), fitClient);
        }
    }

    static class FitTestSystemFactory
    implements TestSystemFactory {
        FitTestSystemFactory() {
        }

        @Override
        public FitTestSystem create(Descriptor descriptor) {
            FitClientBuilder clientBuilder = new FitClientBuilder(descriptor);
            CommandRunningFitClient fitClient = clientBuilder.build();
            return new FitTestSystem(clientBuilder.getTestSystemName(), fitClient);
        }
    }

    static class InProcessHtmlSlimTestSystemFactory
    implements TestSystemFactory {
        private final SlimTableFactory slimTableFactory;
        private final CustomComparatorRegistry customComparatorRegistry;
        private ClassLoader classLoader;

        public InProcessHtmlSlimTestSystemFactory(SlimTableFactory slimTableFactory, CustomComparatorRegistry customComparatorRegistry, ClassLoader classLoader) {
            this.slimTableFactory = slimTableFactory;
            this.customComparatorRegistry = customComparatorRegistry;
            this.classLoader = classLoader;
        }

        @Override
        public TestSystem create(Descriptor descriptor) {
            InProcessSlimClientBuilder clientBuilder = new InProcessSlimClientBuilder(descriptor, this.classLoader);
            SlimClient slimClient = clientBuilder.build();
            HtmlSlimTestSystem testSystem = new HtmlSlimTestSystem(clientBuilder.getTestSystemName(), slimClient, this.slimTableFactory.copy(), this.customComparatorRegistry);
            return testSystem;
        }
    }

    static class HtmlSlimTestSystemFactory
    implements TestSystemFactory {
        private final SlimTableFactory slimTableFactory;
        private final CustomComparatorRegistry customComparatorRegistry;

        public HtmlSlimTestSystemFactory(SlimTableFactory slimTableFactory, CustomComparatorRegistry customComparatorRegistry) {
            this.slimTableFactory = slimTableFactory;
            this.customComparatorRegistry = customComparatorRegistry;
        }

        @Override
        public final TestSystem create(Descriptor descriptor) {
            SlimClientBuilder clientBuilder = new SlimClientBuilder(descriptor);
            SlimCommandRunningClient slimClient = clientBuilder.build();
            HtmlSlimTestSystem testSystem = new HtmlSlimTestSystem(clientBuilder.getTestSystemName(), slimClient, this.slimTableFactory.copy(), this.customComparatorRegistry);
            return testSystem;
        }
    }
}

