/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testrunner;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiSourcePage;
import fitnesse.wiki.WikitextPage;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Paths;
import fitnesse.wikitext.parser.Symbol;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ClassPathBuilder {
    public List<String> getClassPath(WikiPage page) {
        List<String> paths = this.getInheritedPathElements(page);
        return this.createClassPath(paths);
    }

    private List<String> getInheritedPathElements(WikiPage page) {
        final ArrayList<String> items = new ArrayList<String>();
        page.getPageCrawler().traversePageAndAncestors((TraversalListener<? super WikiPage>)new TraversalListener<WikiPage>(){

            @Override
            public void process(WikiPage p) {
                items.addAll(ClassPathBuilder.this.getItemsFromPage(p));
            }
        });
        return items;
    }

    public List<String> createClassPath(List<String> paths) {
        paths = this.expandWildcards(paths);
        HashSet<String> addedPaths = new HashSet<String>();
        ArrayList<String> classPath = new ArrayList<String>();
        for (String path : paths) {
            if (addedPaths.contains(path)) continue;
            addedPaths.add(path);
            classPath.add(path);
        }
        return classPath;
    }

    private List<String> expandWildcards(List<String> paths) {
        ArrayList<String> allPaths = new ArrayList<String>();
        for (String path : paths) {
            allPaths.addAll(this.expandWildcard(path));
        }
        return allPaths;
    }

    private List<String> expandWildcard(String path) {
        ArrayList<String> allPaths = new ArrayList<String>();
        File file = new File(path);
        File dir = new File(file.getAbsolutePath()).getParentFile();
        if (this.isExpandableDoubleWildcard(path, dir)) {
            allPaths.addAll(this.recursivelyAddMatchingFiles(path, dir));
        } else if (this.isExpandableSingleWildcard(path, dir)) {
            allPaths.addAll(this.getMatchingFiles(path, dir));
        } else {
            allPaths.add(path);
        }
        return allPaths;
    }

    private List<String> recursivelyAddMatchingFiles(String path, File dir) {
        String singleWildcardPath = this.convertDoubleToSingleWildcard(path);
        return this.getMatchingSubfiles(singleWildcardPath, dir);
    }

    private boolean isExpandableSingleWildcard(String path, File dir) {
        return this.pathHasSingleWildcard(path) && dir.exists();
    }

    private boolean isExpandableDoubleWildcard(String path, File dir) {
        return this.pathHasDoubleWildCard(path) && dir.exists();
    }

    private boolean pathHasSingleWildcard(String path) {
        return path.indexOf(42) != -1;
    }

    private String convertDoubleToSingleWildcard(String path) {
        path = path.replaceFirst("\\*\\*", "*");
        return path;
    }

    private boolean pathHasDoubleWildCard(String path) {
        return path.contains("**");
    }

    private List<String> getMatchingFiles(String path, File dir) {
        String fileName = new File(path).getName();
        File[] files = dir.listFiles(new Wildcard(fileName));
        ArrayList<String> allPaths = new ArrayList<String>();
        for (File file : files) {
            allPaths.add(file.getPath());
        }
        return allPaths;
    }

    private List<String> getMatchingSubfiles(String path, File dir) {
        ArrayList<String> allPaths = new ArrayList<String>();
        allPaths.addAll(this.getMatchingFiles(path, dir));
        for (File file : dir.listFiles()) {
            if (!file.isDirectory()) continue;
            allPaths.addAll(this.getMatchingSubfiles(path, file));
        }
        return allPaths;
    }

    protected List<String> getItemsFromPage(WikiPage page) {
        if (page instanceof WikitextPage) {
            Symbol tree = ((WikitextPage)((Object)page)).getSyntaxTree();
            ParsingPage parsingPage = ((WikitextPage)((Object)page)).getParsingPage();
            return new Paths(new HtmlTranslator(new WikiSourcePage(page), parsingPage)).getPaths(tree);
        }
        return Collections.emptyList();
    }

    public static class Wildcard
    implements FilenameFilter {
        private String pattern;
        private String prefix;
        private String suffix;
        private int length;

        public Wildcard(String pattern) {
            int starIndex = pattern.indexOf("*");
            if (starIndex > -1) {
                this.prefix = pattern.substring(0, starIndex);
                this.suffix = pattern.substring(starIndex + 1);
                this.length = this.prefix.length() + this.suffix.length();
            } else {
                this.pattern = pattern;
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            if (this.pattern != null) {
                return this.pattern.equals(name);
            }
            boolean goodLength = name.length() >= this.length;
            boolean goodPrefix = name.startsWith(this.prefix);
            boolean goodSufix = name.endsWith(this.suffix);
            return goodLength && goodPrefix && goodSufix;
        }
    }
}

