/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.test.statementexecutorconsumer;

import fitnesse.slim.SlimSymbol;
import fitnesse.slim.StatementExecutorConsumer;
import fitnesse.slim.StatementExecutorInterface;
import java.util.List;
import java.util.regex.Matcher;

public abstract class SymbolManagingTableTable
implements StatementExecutorConsumer {
    private StatementExecutorInterface context;

    @Override
    public void setStatementExecutor(StatementExecutorInterface statementExecutor) {
        this.context = statementExecutor;
        this.context.assign("SLIM_AGENT_FIXTURE_HANDLES_SYMBOLS", "tableTable.*\\.doTable");
    }

    protected StatementExecutorInterface getStatementExecutor() {
        return this.context;
    }

    public List<List<String>> doTable(List<List<String>> table) {
        try {
            List<List<String>> list = this.doTableImpl(table);
            return list;
        }
        finally {
            this.context.assign("SLIM_AGENT_FIXTURE_HANDLES_SYMBOLS", null);
        }
    }

    protected abstract List<List<String>> doTableImpl(List<List<String>> var1);

    protected String replaceSymbolsInString(String arg) {
        Matcher symbolMatcher;
        int startingPosition = 0;
        while (!"".equals(arg) && null != arg && (symbolMatcher = SlimSymbol.SYMBOL_PATTERN.matcher(arg)).find(startingPosition)) {
            arg = this.replaceSymbolInArg(symbolMatcher, arg);
            startingPosition = symbolMatcher.start(1);
        }
        return arg;
    }

    protected String replaceSymbolInArg(Matcher symbolMatcher, String arg) {
        String replacement = "null";
        Object value = this.getSymbolValue(symbolMatcher);
        if (value != null) {
            replacement = value.toString();
        }
        String prefix = arg.substring(0, symbolMatcher.start());
        String postfix = arg.substring(symbolMatcher.end());
        arg = prefix + replacement + postfix;
        return arg;
    }

    protected Object getSymbolValue(Matcher symbolMatcher) {
        String symbolName = symbolMatcher.group(1);
        return this.context.getSymbolObject(symbolName);
    }

    protected boolean assignSymbolIfApplicable(String text, Object value) {
        boolean result;
        String symbol = SlimSymbol.isSymbolAssignment(text);
        boolean bl = result = symbol != null;
        if (result) {
            this.context.assign(symbol, value);
        }
        return result;
    }
}

