/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.instructions;

import fitnesse.slim.SlimException;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.InstructionExecutor;
import fitnesse.slim.instructions.InstructionResult;

public class ImportInstruction
extends Instruction {
    public static final String INSTRUCTION = "import";
    private String path;

    public ImportInstruction(String id, String path) {
        super(id);
        this.path = path;
    }

    @Override
    protected InstructionResult executeInternal(InstructionExecutor executor) throws SlimException {
        executor.addPath(this.path);
        return new InstructionResult.Ok(this.getId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id='").append(this.getId()).append('\'');
        sb.append(", instruction='").append(INSTRUCTION).append('\'');
        sb.append(", path='").append(this.path).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImportInstruction that = (ImportInstruction)o;
        return this.path.equals(that.path);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }
}

