/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.converters;

import fitnesse.slim.Converter;
import fitnesse.slim.converters.ConverterBase;
import fitnesse.slim.converters.ElementConverterHelper;
import fitnesse.slim.converters.ListConverterHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;

public class GenericCollectionConverter<T, C extends Collection<T>>
extends ConverterBase<C> {
    public static final Map<Class<?>, Class<?>> DEFAULT_COLLECTION_IMPL = new HashMap();
    private final Class<C> collectionClass;
    private final Converter<T> componentConverter;

    public GenericCollectionConverter(Class<?> collectionClass, Converter<T> componentConverter) {
        if (collectionClass.isInterface()) {
            collectionClass = DEFAULT_COLLECTION_IMPL.get(collectionClass);
        }
        this.collectionClass = collectionClass;
        this.componentConverter = componentConverter;
    }

    @Override
    public String getString(C collection) {
        int size = collection.size();
        ArrayList<String> ret = new ArrayList<String>(size);
        for (Object item : collection) {
            ret.add(this.getElementString(item));
        }
        return ListConverterHelper.toString(ret);
    }

    private String getElementString(T item) {
        String result = item == null ? this.componentConverter.toString(item) : ElementConverterHelper.elementToString(item);
        return result;
    }

    @Override
    public C getObject(String arg) {
        String[] strings;
        Collection collection;
        try {
            collection = (Collection)this.collectionClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Collection should have a default constructor", e);
        }
        for (String string : strings = ListConverterHelper.fromStringToArrayOfStrings(arg)) {
            collection.add(this.componentConverter.fromString(string));
        }
        return (C)collection;
    }

    static {
        DEFAULT_COLLECTION_IMPL.put(List.class, ArrayList.class);
        DEFAULT_COLLECTION_IMPL.put(Set.class, HashSet.class);
        DEFAULT_COLLECTION_IMPL.put(Queue.class, PriorityQueue.class);
        DEFAULT_COLLECTION_IMPL.put(Collection.class, ArrayList.class);
    }
}

