/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.converters;

import fitnesse.slim.Converter;
import fitnesse.slim.converters.ConverterBase;
import fitnesse.slim.converters.ElementConverterHelper;
import fitnesse.slim.converters.ListConverterHelper;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class GenericArrayConverter<T>
extends ConverterBase<Object> {
    private final Class<T> componentClass;
    private final Converter<T> componentConverter;

    public GenericArrayConverter(Class<T> componentClass, Converter<T> componentConverter) {
        this.componentClass = componentClass;
        this.componentConverter = componentConverter;
    }

    @Override
    public String getString(Object array) {
        int size = Array.getLength(array);
        ArrayList<String> ret = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            ret.add(this.getElementString(array, i));
        }
        return ((Object)ret).toString();
    }

    private String getElementString(Object array, int i) {
        Object element = Array.get(array, i);
        String result = element == null ? this.componentConverter.toString(element) : ElementConverterHelper.elementToString(element);
        return result;
    }

    @Override
    public Object getObject(String arg) {
        String[] strings = ListConverterHelper.fromStringToArrayOfStrings(arg);
        Object array = Array.newInstance(this.componentClass, strings.length);
        for (int i = 0; i < strings.length; ++i) {
            Array.set(array, i, this.componentConverter.fromString(strings[i]));
        }
        return array;
    }
}

