/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.converters;

import fitnesse.slim.Converter;
import fitnesse.slim.converters.BooleanConverter;
import fitnesse.slim.converters.CharConverter;
import fitnesse.slim.converters.DateConverter;
import fitnesse.slim.converters.DefaultConverter;
import fitnesse.slim.converters.DoubleConverter;
import fitnesse.slim.converters.GenericArrayConverter;
import fitnesse.slim.converters.GenericCollectionConverter;
import fitnesse.slim.converters.GenericEnumConverter;
import fitnesse.slim.converters.IntConverter;
import fitnesse.slim.converters.LongConverter;
import fitnesse.slim.converters.MapConverter;
import fitnesse.slim.converters.PrimitiveBooleanConverter;
import fitnesse.slim.converters.PrimitiveCharConverter;
import fitnesse.slim.converters.PrimitiveDoubleConverter;
import fitnesse.slim.converters.PrimitiveIntConverter;
import fitnesse.slim.converters.PrimitiveLongConverter;
import fitnesse.slim.converters.StringConverter;
import fitnesse.slim.converters.VoidConverter;
import fitnesse.slim.converters.beans.JavaBeansConverterGateway;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConverterRegistry {
    private static final Map<Class<?>, Converter<?>> converters = new HashMap();
    private static Converter<Object> defaultConverter = new DefaultConverter();

    private ConverterRegistry() {
    }

    public static void resetToStandardConverters() {
        converters.clear();
        ConverterRegistry.addStandardConverters();
    }

    protected static void addStandardConverters() {
        ConverterRegistry.addConverter(Void.TYPE, new VoidConverter());
        ConverterRegistry.addConverter(String.class, new StringConverter());
        ConverterRegistry.addConverter(Date.class, new DateConverter());
        ConverterRegistry.addConverter(Double.class, new DoubleConverter());
        ConverterRegistry.addConverter(Double.TYPE, new PrimitiveDoubleConverter());
        ConverterRegistry.addConverter(Long.class, new LongConverter());
        ConverterRegistry.addConverter(Long.TYPE, new PrimitiveLongConverter());
        ConverterRegistry.addConverter(Integer.class, new IntConverter());
        ConverterRegistry.addConverter(Integer.TYPE, new PrimitiveIntConverter());
        ConverterRegistry.addConverter(Character.class, new CharConverter());
        ConverterRegistry.addConverter(Character.TYPE, new PrimitiveCharConverter());
        ConverterRegistry.addConverter(Boolean.class, new BooleanConverter());
        ConverterRegistry.addConverter(Boolean.TYPE, new PrimitiveBooleanConverter());
        try {
            ConverterRegistry.addConverter(Map.class, new MapConverter());
        }
        catch (NoClassDefFoundError e) {
            System.err.println("Slim  Map converter not loaded: could not find class " + e.getMessage());
        }
    }

    public static <T> Converter<T> getConverterForClass(Class<T> clazz) {
        return ConverterRegistry.getConverterForClass(clazz, null);
    }

    public static <T> Converter<T> getConverterForClass(Class<? extends T> clazz, ParameterizedType typedClazz) {
        if (converters.containsKey(clazz)) {
            return converters.get(clazz);
        }
        for (Class<T> superclass = clazz.getSuperclass(); superclass != null && !Object.class.equals(superclass); superclass = superclass.getSuperclass()) {
            if (!converters.containsKey(superclass)) continue;
            return converters.get(superclass);
        }
        Converter<T> converterForInterface = ConverterRegistry.getConverterForInterface(clazz);
        if (converterForInterface != null) {
            return converterForInterface;
        }
        Converter<? extends T> javaBeansConverter = JavaBeansConverterGateway.getConverter(clazz);
        if (javaBeansConverter != null) {
            return javaBeansConverter;
        }
        if (clazz.isEnum()) {
            return new GenericEnumConverter<T>(clazz);
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            Converter<?> converterForClass = ConverterRegistry.getConverterForClassOrDefaultConverter(componentType);
            return new GenericArrayConverter(componentType, converterForClass);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Class componentType = typedClazz != null ? (Class)typedClazz.getActualTypeArguments()[0] : String.class;
            Converter<?> converterForClass = ConverterRegistry.getConverterForClassOrDefaultConverter(componentType);
            return new GenericCollectionConverter(clazz, converterForClass);
        }
        return converters.get(Object.class);
    }

    protected static <T> Converter<T> getConverterForInterface(Class<?> clazz) {
        ArrayList superInterfaces = new ArrayList();
        Converter<Object> converterForInterface = null;
        Class<?>[] interfaces = clazz.getInterfaces();
        for (Class<?> interf : interfaces) {
            Class<?>[] s = interf.getInterfaces();
            superInterfaces.addAll(Arrays.asList(s));
            if (!converters.containsKey(interf)) continue;
            converterForInterface = converters.get(interf);
            break;
        }
        if (converterForInterface == null) {
            Class supInterf;
            Iterator iterator = superInterfaces.iterator();
            while (iterator.hasNext() && (converterForInterface = ConverterRegistry.getConverterForInterface(supInterf = (Class)iterator.next())) == null) {
            }
            if (converterForInterface == null) {
                for (Class<?> superclass = clazz.getSuperclass(); superclass != null && !Object.class.equals(superclass) && (converterForInterface = ConverterRegistry.getConverterForInterface(superclass)) == null; superclass = superclass.getSuperclass()) {
                }
            }
        }
        return converterForInterface;
    }

    public static <T> void addConverter(Class<? extends T> clazz, Converter<T> converter) {
        converters.put(clazz, converter);
    }

    public static void removeConverter(Class<?> clazz) {
        converters.remove(clazz);
    }

    public static Map<Class<?>, Converter<?>> getConverters() {
        return Collections.unmodifiableMap(converters);
    }

    public static Converter<?> getConverterForClassOrDefaultConverter(Class<?> clazz) {
        Converter<Object> converter = ConverterRegistry.getConverterForClass(clazz);
        if (converter == null) {
            converter = defaultConverter;
        }
        return converter;
    }

    static {
        ConverterRegistry.addStandardConverters();
    }
}

