/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.SlimExpressionEvaluator;
import fitnesse.slim.SlimSymbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariableStore {
    private Map<String, MethodExecutionResult> variables = new HashMap<String, MethodExecutionResult>();

    public void setSymbol(String name, MethodExecutionResult value) {
        this.variables.put(name, value);
    }

    public MethodExecutionResult getSymbol(String name) {
        return this.variables.get(name);
    }

    public Object getStored(String nameWithDollar) {
        if (nameWithDollar == null || !nameWithDollar.startsWith("$")) {
            return null;
        }
        if (nameWithDollar.startsWith("$`") && nameWithDollar.endsWith("`")) {
            String expr = nameWithDollar.substring(2, nameWithDollar.length() - 1);
            return this.evaluate(expr);
        }
        String name = nameWithDollar.substring(1);
        if (!this.variables.containsKey(name)) {
            return null;
        }
        return this.variables.get(name).getObject();
    }

    private boolean containsValueFor(String nameWithDollar) {
        boolean result = false;
        if (nameWithDollar != null) {
            if (nameWithDollar.startsWith("$`") && nameWithDollar.endsWith("`")) {
                result = true;
            } else if (nameWithDollar.startsWith("$") && this.variables.containsKey(nameWithDollar.substring(1))) {
                result = true;
            }
        }
        return result;
    }

    public Object[] replaceSymbols(Object[] args) {
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = this.replaceSymbol(args[i]);
        }
        return result;
    }

    private List<Object> replaceSymbolsInList(List<Object> objects) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : objects) {
            result.add(this.replaceSymbol(object));
        }
        return result;
    }

    private Object replaceSymbol(Object object) {
        if (object instanceof List) {
            return this.replaceSymbolsInList((List)object);
        }
        if (this.containsValueFor((String)object)) {
            return this.getStored((String)object);
        }
        return this.replaceSymbolsInString((String)object);
    }

    public String replaceSymbolsInString(String arg) {
        if (SlimSymbol.isSymbolAssignment(arg) != null) {
            return "";
        }
        return new SlimSymbol(){

            @Override
            protected String getSymbolValue(String symbolName) {
                return VariableStore.this.getStoreSymbolValue(symbolName);
            }
        }.replace(arg);
    }

    private String getStoreSymbolValue(String symbolName) {
        if (symbolName.startsWith("`") && symbolName.endsWith("`")) {
            Object value = this.getStored("$" + symbolName);
            return String.valueOf(value);
        }
        if (this.variables.containsKey(symbolName)) {
            MethodExecutionResult value = this.variables.get(symbolName);
            return String.valueOf(value);
        }
        return null;
    }

    private Object evaluate(String expr) {
        SlimExpressionEvaluator evaluator = this.getEvaluatorForExpression(expr);
        Object value = null;
        try {
            value = evaluator.evaluate(expr);
        }
        catch (IllegalArgumentException e) {
            value = e.getMessage();
        }
        return value;
    }

    protected SlimExpressionEvaluator getEvaluatorForExpression(String expr) {
        SlimExpressionEvaluator evaluator = new SlimExpressionEvaluator();
        evaluator.setContext(expr, this.variables);
        return evaluator;
    }
}

