/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.SlimError;
import fitnesse.slim.SlimException;
import fitnesse.slim.StatementExecutorInterface;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class StatementTimeoutExecutor
implements StatementExecutorInterface {
    private final StatementExecutorInterface inner;
    private final Integer timeout;
    private final ExecutorService service;

    private StatementTimeoutExecutor(StatementExecutorInterface inner, Integer timeout, ExecutorService service) {
        this.inner = inner;
        this.timeout = timeout;
        this.service = service;
    }

    public static StatementExecutorInterface decorate(StatementExecutorInterface inner, Integer timeout) {
        return StatementTimeoutExecutor.decorate(inner, timeout, Executors.newSingleThreadExecutor());
    }

    public static StatementExecutorInterface decorate(StatementExecutorInterface inner, Integer timeout, ExecutorService service) {
        return new StatementTimeoutExecutor(inner, timeout, service);
    }

    @Override
    public void assign(String name, Object value) {
        this.inner.assign(name, value);
    }

    @Override
    public Object getSymbol(String symbolName) {
        return this.inner.getSymbol(symbolName);
    }

    @Override
    public Object getSymbolObject(String symbolName) {
        return this.inner.getSymbolObject(symbolName);
    }

    @Override
    public Object getInstance(String instanceName) {
        return this.inner.getInstance(instanceName);
    }

    @Override
    public boolean stopHasBeenRequested() {
        return this.inner.stopHasBeenRequested();
    }

    @Override
    public void reset() {
        this.inner.reset();
    }

    @Override
    public void setInstance(String actorInstanceName, Object actor) {
        this.inner.setInstance(actorInstanceName, actor);
    }

    @Override
    public void addPath(String path) throws SlimException {
        this.inner.addPath(path);
    }

    @Override
    public void create(final String instanceName, final String className, final Object ... constructorArgs) throws SlimException {
        Future<Boolean> submit = this.service.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                StatementTimeoutExecutor.this.inner.create(instanceName, className, constructorArgs);
                return true;
            }
        });
        this.getWithTimeout(submit);
    }

    @Override
    public Object callAndAssign(final String symbolName, final String instanceName, final String methodsName, final Object ... arguments) throws SlimException {
        Future<Object> submit = this.service.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return StatementTimeoutExecutor.this.inner.callAndAssign(symbolName, instanceName, methodsName, arguments);
            }
        });
        return this.getWithTimeout(submit);
    }

    @Override
    public Object call(final String instanceName, final String methodName, final Object ... arguments) throws SlimException {
        Future<Object> submit = this.service.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return StatementTimeoutExecutor.this.inner.call(instanceName, methodName, arguments);
            }
        });
        return this.getWithTimeout(submit);
    }

    private <T> T getWithTimeout(Future<T> submit) throws SlimException {
        try {
            return submit.get(this.timeout.intValue(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new SlimException(Integer.toString(this.timeout), "TIMED_OUT", true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SlimError("Statement execution was interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SlimException) {
                throw (SlimException)cause;
            }
            throw new SlimException(e.getCause());
        }
    }
}

