/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SlimSymbol {
    public static final Pattern SYMBOL_PATTERN = Pattern.compile("\\$(([A-Za-z\\p{L}][\\w\\p{L}]*)|`([^`]+)`)");
    public static final Pattern SYMBOL_ASSIGNMENT_PATTERN = Pattern.compile("\\A\\s*\\$([A-Za-z\\p{L}][\\w\\p{L}]*)\\s*=\\s*\\Z");
    protected String replacedString;
    private Matcher symbolMatcher;
    private int startingPosition;

    public static final String isSymbolAssignment(String content) {
        if (content == null) {
            return null;
        }
        Matcher matcher = SYMBOL_ASSIGNMENT_PATTERN.matcher(content);
        return matcher.find() ? matcher.group(1) : null;
    }

    public String replace(String s) {
        if (null == s) {
            return null;
        }
        if (SlimSymbol.isSymbolAssignment(s) != null) {
            return s;
        }
        this.replacedString = s;
        this.symbolMatcher = SYMBOL_PATTERN.matcher(s);
        this.replaceAllSymbols();
        return this.replacedString;
    }

    private void replaceAllSymbols() {
        this.startingPosition = 0;
        while (this.symbolFound()) {
            this.replaceSymbol();
        }
    }

    private void replaceSymbol() {
        String symbolName = this.symbolMatcher.group(1);
        String value = this.formatSymbol(symbolName);
        String prefix = this.replacedString.substring(0, this.symbolMatcher.start());
        String suffix = this.replacedString.substring(this.symbolMatcher.end());
        this.replacedString = prefix + value + suffix;
        int replacementEnd = this.symbolMatcher.start() + value.length();
        this.startingPosition = Math.min(replacementEnd, this.replacedString.length());
    }

    protected String formatSymbol(String symbolName) {
        String value = this.getSymbolValue(symbolName);
        if (value == null) {
            return this.symbolMatcher.group();
        }
        return this.formatSymbolValue(symbolName, value);
    }

    private boolean symbolFound() {
        this.symbolMatcher = SYMBOL_PATTERN.matcher(this.replacedString);
        return this.symbolMatcher.find(this.startingPosition);
    }

    protected String formatSymbolValue(String name, String value) {
        return value;
    }

    protected abstract String getSymbolValue(String var1);
}

